$(document).ready(function() {
    // ✅ Use event delegation
    $(document).on('click', '.add-to-cart-btn', function(e) {
        e.preventDefault();

        const btn = $(this);
        const productId = btn.data('id');
        const spinner = btn.find('.spinner-border');
        const text = btn.find('.btn-text');

        // Start loading state
        spinner.removeClass('d-none');
        text.text('Adding...');

        $.ajax({
            url: 'api/cart/add_to_cart.php',
            type: 'POST',
            data: { id: productId },
            dataType: 'json',
            success: function(response) {
                spinner.addClass('d-none');
                text.text('Add to cart');

                if (response.status === 'success') {
                    toastr.success(response.message, 'Success');

                    // ✅ Update dropdown content
                    $('#cart-dropdown').html(response.cart_html);

                    // ✅ Update count and total
                    $('#cart-count').text('(' + response.cart_count + ')');
                    $('#cart-total').text('- Ksh ' + response.cart_total.toFixed(2));
                } else {
                    toastr.error(response.message, 'Error');
                }
            },
            error: function() {
                spinner.addClass('d-none');
                text.text('Add to cart');
                toastr.error('Something went wrong. Try again later.', 'Error');
            }
        });
    });

    // ✅ Load cart summary on page load
    $.getJSON('api/cart/load_cart.php', function(response) {
        if (response.status === 'success') {
            $('#cart-dropdown').html(response.cart_html);
            $('#cart-count').text('(' + response.cart_count + ')');
            $('#cart-total').text('- Ksh ' + response.cart_total.toFixed(2));
        }
    });
});
