<?php
include_once 'inc/navigation.php';
?>
        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span>Contact Us</span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- Contact page content -->
        <div class="contact-page-area">

            <!-- contact page map -->
            <div class="contact-page-map">
                <!-- Google Map Start -->
                <div class="container">
                   <div id="map" style="width:100%; height:400px; border-radius:10px; overflow:hidden; box-shadow:0 2px 10px rgba(0,0,0,0.1);">
                        <iframe
                            width="100%"
                            height="100%"
                            style="border:0;"
                            loading="lazy"
                            allowfullscreen
                            src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=Nairobi,%20Kenya+(W.Kirei)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed">
                        </iframe>
                    </div>

                </div>
                <!-- Google Map End -->
            </div>
            <!-- contact page map -->

            <!-- contact form area -->
            <div class="contact-form-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                           <div class="contact-form-inner">
                                <h2>GET IN TOUCH WITH US</h2>
                                <form id="contactForm">
                                    <div class="row">
                                        <div class="col">
                                            <input type="text" name="first_name" class="form-control" placeholder="First Name*" required>
                                        </div>
                                        <div class="col">
                                            <input type="text" name="last_name" class="form-control" placeholder="Last Name*" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <input type="email" name="email" class="form-control" placeholder="Email*" required>
                                        </div>
                                        <div class="col">
                                            <input type="text" name="subject" class="form-control" placeholder="Subject*" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <textarea name="message" cols="40" rows="10" class="form-control" placeholder="Message*" required></textarea>
                                        </div>
                                    </div>
                                    <div class="contact-submit mt-3">
                                        <button type="submit" class="btn btn-primary" id="submitBtn">
                                            <span id="btnText">Send Message</span>
                                            <span id="spinner" style="display:none;"><i class="fas fa-spinner fa-spin"></i> Sending...</span>
                                        </button>
                                    </div>
                                    <div id="formResponse" class="mt-3"></div>
                                </form>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="contact-address-area">
                                <h2>CONTACT US</h2>
                                <p>We're here to help and answer any questions you might have. Reach out to us and we'll respond as soon as we can.</p>
                                <ul>
                                    <li>
                                        <i class="fa fa-fax">&nbsp;</i> Address: <?php echo $site_address; ?>
                                    </li>
                                    <li>
                                        <i class="fa fa-phone">&nbsp;</i> Email: <a href="mailto:<?php echo $site_email; ?>"><?php echo $site_email; ?></a>
                                    </li>
                                    <li>
                                        <i class="fa fa-envelope-o">&nbsp;</i> Phone: <a href="tel:<?php echo $site_phone; ?>"><?php echo $site_phone; ?></a>
                                    </li>
                                </ul>
                                <h3><strong>Working hours</strong></h3>
                                <p><strong>Monday – Saturday</strong>: 08:00 AM – 7:00 PM</p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- contact form area end -->

        </div>
        <!-- Contact page content end -->
<?php
include_once 'inc/footer.php';
?>
<script>
$(document).ready(function() {
    $('#contactForm').on('submit', function(e) {
        e.preventDefault();

        $('#btnText').hide();
        $('#spinner').show();
        $('#formResponse').html('');

        let formData = $(this).serialize();

        $.ajax({
            url: 'api/action/contact_submit.php',
            type: 'POST',
            data: formData,
            dataType: 'json', // <-- This tells jQuery to parse JSON automatically
            success: function(res) { // Already an object
                //console.log('Parsed response:', res);

                $('#spinner').hide();
                $('#btnText').show();

                if(res.status === 'success') {
                    //console.log('Form submission successful:', res.message);
                    $('#formResponse').html('<div class="alert alert-success">'+res.message+'</div>');
                    $('#contactForm')[0].reset();
                } else {
                    console.warn('Form submission error:', res.message);
                    $('#formResponse').html('<div class="alert alert-danger">'+res.message+'</div>');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                //console.error('AJAX error:', textStatus, errorThrown, jqXHR.responseText);
                $('#spinner').hide();
                $('#btnText').show();
                $('#formResponse').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
            }
        });

    });
});
</script>
