<?php 
include_once 'inc/navigation.php'
?>

        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span>Checkout</span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- checkout page content -->
        <div class="checkout-page-area">

            <!-- coupon area -->
            <div class="coupon-area">
                <div class="container">
                    <div class="coupon-accordion">
                        <?php if(empty($_SESSION['user_id'])): ?>
                        <h3>Returning customer? <span id="showlogin" style="cursor:pointer; color:#007bff;">Click here to login</span></h3>
                        <div id="checkout-login" class="coupon-content" style="display:none;">
                            <div class="coupon-info">
                            <p class="coupon-text">
                                    If you already have an account with us, please log in below to access your saved information, track your orders, and speed up checkout.
                                </p>

                                <form id="loginForm">
                                    <p class="form-row-first">
                                        <label>Username or email <span class="required">*</span></label>
                                        <input type="text" name="username" required>
                                    </p>
                                    <p class="form-row-last">
                                        <label>Password  <span class="required">*</span></label>
                                        <input type="password" name="password" required>
                                    </p>
                                    <p class="form-row">
                                    <button type="submit" class="btn btn-primary login-btn" id="loginBtn">
                                            <span id="btnText">Login</span>
                                            <span id="spinner" style="display:none;"><i class="fa fa-spinner fa-spin"></i></span>
                                        </button>

                                        <label>
                                            <input type="checkbox" name="remember"> Remember me 
                                        </label>
                                    </p>
                                    <p class="lost-password">
                                        <a href="#">Lost your password?</a>
                                    </p>
                                    <p>
                                        <!-- Google Login Button -->
                                        <button type="button" class="btn btn-danger" id="googleLogin">
                                            <i class="fa fa-google"></i> Login with Google
                                        </button>
                                    </p>
                                    <div id="loginResponse" class="mt-4"></div>
                                </form>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- ACCORDION END -->
                        <!-- ACCORDION START -->
                        <h3>Have a coupon? <span id="showcoupon">Click here to enter your code</span></h3>
                        <div id="checkout_coupon" class="coupon-checkout-content">
                            <div class="coupon-info">
                                <form action="#">
                                    <p class="checkout-coupon">
                                        <input type="text" class="code" placeholder="Coupon code">
                                        <input type="submit" value="Apply Coupon">
                                    </p>
                                </form>
                            </div>
                        </div>
                        <!-- ACCORDION END -->
                    </div>
                </div>
            </div>
            <!-- coupon area end -->
            <?php
            $first_name = $last_name = $email = $phone = $address = $city = '';

            if(!empty($_SESSION['user_id'])){
                $user_id = $_SESSION['user_id'];

                $stmt = $pdo->prepare("
                    SELECT u.username, u.email, u.phone, s.first_name, s.last_name, s.address 
                    FROM users u 
                    LEFT JOIN shipping s ON u.id = s.user_id 
                    WHERE u.id = ?
                ");
                $stmt->execute([$user_id]);
                $user = $stmt->fetch(PDO::FETCH_ASSOC);

                if($user){
                    $first_name = $user['first_name'] ?? '';
                    $last_name  = $user['last_name'] ?? '';
                    $email      = $user['email'] ?? '';
                    $phone      = $user['phone'] ?? '';
                    if(!empty($user['address'])){
                        $parts = explode(',', $user['address']);
                        $address = trim($parts[0]);
                        $city    = trim($parts[1] ?? '');
                    }
                }
            }
            ?>

            <!-- checkout area -->
            <div class="checkout-area">
                <div class="container">
                    <form id="checkoutForm">
                        <div class="row">
                            <!-- Left Column: Billing & Registration -->
                            <div class="col-lg-6 col-md-6">
                            <h3>Billing & Registration</h3>
                            <div class="checkout-form-list mb-20">
                                <label>First Name <span class="required">*</span></label>
                                <input type="text" name="first_name" value="<?= htmlspecialchars($first_name) ?>" required>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>Last Name <span class="required">*</span></label>
                                <input type="text" name="last_name" value="<?= htmlspecialchars($last_name) ?>" required>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>Email <span class="required">*</span></label>
                                <input type="email" name="email" value="<?= htmlspecialchars($email) ?>" required>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>Phone <span class="required">*</span></label>
                                <input type="text" name="phone" value="<?= htmlspecialchars($phone) ?>" required>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>Password <span class="required">*</span></label>
                                <input type="password" name="password" placeholder="Enter password" <?= empty($user_id) ? 'required' : '' ?>>
                                <?php if(!empty($user_id)): ?>
                                    <small class="text-muted">Leave blank to keep your current password</small>
                                <?php endif; ?>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>Address <span class="required">*</span></label>
                                <input type="text" name="address" value="<?= htmlspecialchars($address) ?>" required>
                            </div>

                            <div class="checkout-form-list mb-20">
                                <label>City <span class="required">*</span></label>
                                <input type="text" name="city" value="<?= htmlspecialchars($city) ?>" required>
                            </div>
                            </div>

                            <!-- Right Column: Order Summary -->
                            <div class="col-lg-6 col-md-6">
                                <div class="your-order">
                                    <h3>Your Order</h3>
                                    <div class="your-order-table table-responsive">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <th class="product-name">Product</th>
                                                    <th class="product-total">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody id="orderItems">
                                                <?php
                                                $cartTotal = 0;
                                                if(!empty($_SESSION['cart'])){
                                                    foreach($_SESSION['cart'] as $item){
                                                        $total = $item['price'] * $item['quantity'];
                                                        $cartTotal += $total;
                                                        echo '<tr class="cart_item">';
                                                        echo '<td class="product-name">'.htmlspecialchars($item['name']).' <strong class="product-quantity"> × '.$item['quantity'].'</strong></td>';
                                                        echo '<td class="product-total"><span class="amount">Ksh '.number_format($total,2).'</span></td>';
                                                        echo '</tr>';
                                                    }
                                                } else {
                                                    echo '<tr><td colspan="2" class="text-center text-muted">Cart is empty.</td></tr>';
                                                }
                                                ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="cart-subtotal">
                                                    <th>Cart Subtotal</th>
                                                    <td><span class="amount" id="cartSubtotal">Ksh <?= number_format($cartTotal,2) ?></span></td>
                                                </tr>
                                                <tr class="order-total">
                                                    <th>Order Total</th>
                                                    <td><strong><span class="amount" id="cartTotal">Ksh <?= number_format($cartTotal,2) ?></span></strong></td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>

                                    <!-- Place Order Button -->
                                    <div class="order-button-payment mt-3">
                                        <button type="submit" class="btn btn-primary text-white" id="checkoutBtn">
                                            <span id="btnText">Place Order</span>
                                            <span id="spinner" style="display:none;"><i class="fa fa-spinner fa-spin"></i></span>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            </div>
                        </div>
                    </form>

                </div>

            </div>
            <!-- checkout area end -->

        </div>
        <!-- checkout page content end -->

        <div id="processingOverlay" style="
            display:none;
            position:fixed;
            top:0; left:0;
            width:100%; height:100%;
            background: rgba(0,0,0,0.6);
            z-index:9999;
            color:#fff;
            font-family:Arial, sans-serif;
            text-align:center;
        ">
            <div style="
                position:absolute;
                top:50%; left:50%;
                transform:translate(-50%, -50%);
            ">
                <i class="fa fa-spinner fa-spin" style="font-size:50px;"></i>
                <h2 style="margin-top:20px;">Processing your payment...</h2>
                <p>Please do not close this page.</p>
            </div>
        </div>

<?php
include_once 'inc/footer.php';
?>
<script src="https://js.paystack.co/v1/inline.js"></script>
<script>
$(document).ready(function() {
    // Toggle login form
    $('#showlogin').on('click', function() {
        $('#checkout-login').slideToggle();
    });

    // AJAX Login
    $('#loginForm').on('submit', function(e){
        e.preventDefault();

        $('#btnText').hide();
        $('#spinner').show();
        $('#loginResponse').html('');

        $.ajax({
            url: 'api/action/login.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(res){
                $('#spinner').hide();
                $('#btnText').show();

                if(res.status === 'success'){
                    $('#loginResponse').html('<div class="alert alert-success">'+res.message+'</div>');
                    setTimeout(() => { location.reload(); }, 1000); // reload to update UI
                } else {
                    $('#loginResponse').html('<div class="alert alert-danger">'+res.message+'</div>');
                }
            },
            error: function(){
                $('#spinner').hide();
                $('#btnText').show();
                $('#loginResponse').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
            }
        });
    });

    // Google Login (redirect to OAuth endpoint)
    $('#googleLogin').on('click', function(){
        window.location.href = 'api/action/google_login.php';
    });



   $("#checkoutForm").on("submit", function(e){
        e.preventDefault();

        // Show spinner
        $("#btnText").hide();
        $("#spinner").show();
        $("#checkoutBtn").prop("disabled", true);

        // Serialize form data
        var formData = $(this).serialize();

        $.ajax({
            url: 'api/action/checkout_action.php',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(res){
                console.log("Checkout response:", res); // Debug checkout_action response

                if(res.status == 'success'){
                    
                    // ✅ Reset the form
                    $("#checkoutForm")[0].reset();

                    // Launch Paystack
                    let handler = PaystackPop.setup({
                        key: 'pk_test_0774cd5e36bcb153ba28be267332ee798068c826', 
                        email: res.email,
                        amount: res.amount * 100, // in kobo
                        currency: 'KES',
                        ref: res.reference, 
                        callback: function(response){
                            console.log("Paystack callback response:", response);

                            // Show the processing overlay
                            $("#processingOverlay").fadeIn();

                            // Make AJAX request to verify payment
                            $.post('api/payments/verify_payment.php', {reference: response.reference}, function(verifyRes){
                                console.log("Verify payment response:", verifyRes);

                                if(verifyRes.status === 'success'){
                                    // Redirect after verification + email
                                    window.location.href = 'thankyou.php';
                                } else {
                                    alert(verifyRes.message || "Payment verification failed.");
                                    $("#processingOverlay").fadeOut();
                                }

                            }, 'json').fail(function(xhr, status, error){
                                console.error("Verify payment AJAX error:", status, error);
                                alert("An error occurred while verifying payment.");
                                $("#processingOverlay").fadeOut();
                            });
                        },
                        onClose: function(){
                            console.log("Paystack payment cancelled");
                            alert('Payment cancelled');
                        }
                    });
                    handler.openIframe();
                } else {
                    console.warn("Checkout failed:", res.message);
                    alert(res.message);
                }

                $("#btnText").show();
                $("#spinner").hide();
                $("#checkoutBtn").prop("disabled", false);
            },
            error: function(xhr, status, error){
                console.error("Checkout AJAX error:", status, error, xhr.responseText);
                alert("Something went wrong. Try again.");
                $("#btnText").show();
                $("#spinner").hide();
                $("#checkoutBtn").prop("disabled", false);
            }
        });

    });


});
</script>