<?php
header('Content-Type: application/json');
require_once '../../inc/dbconn.php';

try {
    if (empty($_POST['product_id']) || empty($_POST['name']) || empty($_POST['email']) || empty($_POST['rating']) || empty($_POST['comment'])) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit;
    }

    $stmt = $pdo->prepare("
        INSERT INTO reviews (product_id, name, email, rating, comment, date)
        VALUES (:product_id, :name, :email, :rating, :comment, NOW())
    ");
    $stmt->execute([
        'product_id' => $_POST['product_id'],
        'name' => $_POST['name'],
        'email' => $_POST['email'],
        'rating' => $_POST['rating'],
        'comment' => $_POST['comment']
    ]);

    echo json_encode([
        'status' => 'success',
        'message' => 'Review added successfully!',
        'review' => [
            'name' => htmlspecialchars($_POST['name']),
            'rating' => (int)$_POST['rating'],
            'comment' => htmlspecialchars($_POST['comment']),
            'date' => date('F d, Y')
        ]
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: '.$e->getMessage()]);
}
?>
