<?php
include '../../inc/dbconn.php';
header('Content-Type: application/json');

// Pagination setup
$limit = 2;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Filters
$whereClauses = ["product_status = 'on'"];
$params = [];

if (!empty($_GET['category'])) {
    $whereClauses[] = "product_cat = :category";
    $params[':category'] = intval($_GET['category']);
}
if (!empty($_GET['brand'])) {
    $whereClauses[] = "product_brand = :brand";
    $params[':brand'] = intval($_GET['brand']);
}
if (!empty($_GET['search'])) {
    $whereClauses[] = "(product_title LIKE :search OR product_keywords LIKE :search)";
    $params[':search'] = "%" . $_GET['search'] . "%";
}

$whereSQL = "WHERE " . implode(" AND ", $whereClauses);

// Sorting
$order = "ORDER BY date DESC";
if (!empty($_GET['sort'])) {
    switch ($_GET['sort']) {
        case 'price_asc': $order = "ORDER BY product_price ASC"; break;
        case 'price_desc': $order = "ORDER BY product_price DESC"; break;
        case 'newest': $order = "ORDER BY date DESC"; break;
    }
}

// Count total
$countStmt = $pdo->prepare("SELECT COUNT(*) FROM products $whereSQL");
$countStmt->execute($params);
$total = $countStmt->fetchColumn();

// Fetch products
$sql = "SELECT * FROM products $whereSQL $order LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($sql);
foreach ($params as $k => $v) $stmt->bindValue($k, $v);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

$products_html = '';
while ($row = $stmt->fetch()) {
    $images = array_map('trim', explode(',', $row['product_image']));
    $img = 'product_images/' . htmlspecialchars($images[0] ?? 'default.png');
    $new_label = $row['new'] === 'yes' ? '<li class="new"><span>New</span></li>' : '';

    $products_html .= '
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="product-miniature js-product-miniature">
            <div class="img_block">
                <a href="product.php?slug=' . htmlspecialchars($row['slug']) . '" class="thumbnail product-thumbnail">
                    <img src="' . $img . '" alt="' . htmlspecialchars($row['product_title']) . '" loading="lazy" style="width:auto; height:250px;object-fit:cover;">
                </a>
                <ul class="product-flag">' . $new_label . '</ul>
            </div>
            <div class="product_desc">
                <div class="manufacturer"><a href="#">Brand #' . htmlspecialchars($row['product_brand']) . '</a></div>
                <h1><a href="product.php?slug=' . htmlspecialchars($row['slug']) . '" class="product_name">' . htmlspecialchars($row['product_title']) . '</a></h1>
                <div class="product-price-and-shipping">
                    <span class="regular-price">Ksh ' . number_format($row['product_price']) . '</span>
                    ' . ($row['old_price'] > 0 ? '<span class="price price-sale">Ksh ' . number_format($row['old_price']) . '</span>' : '') . '
                </div>
                <div class="cart">
                    <div class="product-add-to-cart">
                         <a href="#" class="add-to-cart-btn" data-id="'. $row['product_id'] .'">
                            <span class="btn-text">Add to cart</span>
                            <span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>';
}

// Pagination rendering
$total_pages = ceil($total / $limit);
$pagination_html = '';
if ($total_pages > 1) {
    $visible = 5;
    $start = max(1, $page - 2);
    $end = min($total_pages, $page + 2);

    if ($start > 1) $pagination_html .= '<li><a href="#" class="page-link" data-page="1">1</a></li><li><span>...</span></li>';
    for ($i = $start; $i <= $end; $i++) {
        $active = $i == $page ? 'current' : '';
        $pagination_html .= '<li><a href="#" class="page-link page-numbers ' . $active . '" data-page="' . $i . '">' . $i . '</a></li>';
    }
    if ($end < $total_pages) $pagination_html .= '<li><span>...</span></li><li><a href="#" class="page-link" data-page="' . $total_pages . '">' . $total_pages . '</a></li>';
    if ($page < $total_pages)
        $pagination_html .= '<li><a href="#" class="page-link next page-numbers" data-page="' . ($page + 1) . '">→</a></li>';
}

echo json_encode([
    'products' => $products_html ?: '<div class="text-center w-100 p-4">No products found.</div>',
    'pagination' => $pagination_html
]);
?>

