<?php
session_start();
header('Content-Type: application/json');

$cartHTML = '<div class="text-center p-3 text-muted">Cart is empty.</div>';
$cartCount = 0;
$cartTotal = 0;

if (!empty($_SESSION['cart'])) {
    ob_start();
    $cartTotal = 0;
    echo '<ul>';
    foreach ($_SESSION['cart'] as $item) {
        $cartTotal += $item['price'] * $item['quantity'];
        echo '
        <li>
            <div class="img_content">
                <img class="product-image img-responsive" src="product_images/' . htmlspecialchars($item['image']) . '" alt="' . htmlspecialchars($item['name']) . '"  style="width:100px;height:auto;object-fit:contain;">
                <span class="product-quantity">' . $item['quantity'] . 'x</span>
            </div>
            <div class="right_block">
                <span class="product-name">' . htmlspecialchars($item['name']) . '</span>
                <span class="product-price">Ksh ' . number_format($item['price'], 2) . '</span>
            </div>
        </li>';
    }
    echo '</ul>
    <div class="price_content">
        <div class="cart-total price_inline">
            <span class="label">Total</span>
            <span class="value">Ksh ' . number_format($cartTotal, 2) . '</span>
        </div>
    </div>
    <div class="checkout">
        <a href="cart.php" class="btn btn-primary">View Cart</a>
    </div>';
    $cartHTML = ob_get_clean();
    $cartCount = array_sum(array_column($_SESSION['cart'], 'quantity'));
}

echo json_encode([
    'status' => 'success',
    'cart_html' => $cartHTML,
    'cart_count' => $cartCount,
    'cart_total' => $cartTotal
]);
?>
