<?php
session_start();
header('Content-Type: application/json');

$key = $_POST['key'] ?? null;
$action = $_POST['action'] ?? null;

if ($action === 'remove' && isset($_SESSION['cart'][$key])) {
    unset($_SESSION['cart'][$key]);
}

// Recalculate totals and return updated HTML
$cartItems = $_SESSION['cart'] ?? [];
$cartTotal = 0;
ob_start();

if(!empty($cartItems)) {
    foreach($cartItems as $k => $item){
        $subtotal = $item['price'] * $item['quantity'];
        $cartTotal += $subtotal;
        echo '<tr>
            <td class="product-thumbnail">
                <img src="product_images/'.htmlspecialchars($item['image']).'" style="width:80px;height:80px;object-fit:cover;border-radius:8px;">
            </td>
            <td class="product-name">'.htmlspecialchars($item['name']).'</td>
            <td class="product-price">Ksh '.number_format($item['price'],2).'</td>
            <td class="product-quantity"><input type="number" value="'.$item['quantity'].'"></td>
            <td class="product-subtotal">Ksh '.number_format($subtotal,2).'</td>
            <td class="product-remove"><a href="#" class="remove-item" data-key="'.$k.'"><i class="fa fa-times"></i></a></td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="6" class="text-center text-muted">Cart is empty.</td></tr>';
}

$cartHTML = ob_get_clean();

echo json_encode([
    'status' => 'success',
    'cart_html' => $cartHTML,
    'cart_total' => $cartTotal
]);
