<?php
require '../../inc/dbconn.php';

header('Content-Type: application/json');

if (!isset($_POST['post_id'], $_POST['offset'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid parameters']);
    exit;
}

$post_id = (int)$_POST['post_id'];
$offset = (int)$_POST['offset'];

try {
    $stmt = $pdo->prepare("SELECT * FROM comments WHERE post_id = ? ORDER BY id DESC LIMIT 3 OFFSET ?");
    $stmt->bindParam(1, $post_id, PDO::PARAM_INT);
    $stmt->bindParam(2, $offset, PDO::PARAM_INT);
    $stmt->execute();
    $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['status' => 'success', 'comments' => $comments]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
