<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>

<!-- Page content -->
<div id="page-content">
    <!-- Contacts Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
                <i class="gi gi-parents"></i>Rights<br><small>Manage all user rights & privileges!</small>
            </h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li><a href="">Rights</a></li>
    </ul>
    <!-- END Contacts Header -->

    <!-- Main Row -->
    <div class="row">
        <div class="col-lg-8">
            <!-- Contacts Block -->
            <div class="block">
                <!-- Contacts Title -->
                <div class="block-title">
                    <div class="block-options text-center">
                    </div>
                </div>
                <!-- END Contacts Title -->

                <!-- Contacts Content -->
                <div class="row style-alt">
                    <?php 
                    $get = $connection -> query("SELECT * FROM permission");
                    while($row = $get->fetch_assoc()) {
                    ?>
                    <!-- Contact Widget -->
                    <div class="col-sm-6 col-lg-4">
                        <div class="widget">
                            <div class="widget-simple">
                                <h4 class="widget-content text-right">
                                    <a href="#"><strong><?php echo $row['permission'] ?></strong></a><br>
                                    <span class="btn-group">
                                        <a href="javascript:void(0)" class="btn btn-xs btn-primary" data-toggle="tooltip" title="Edit"><i class="fa fa-pencil"></i></a>
                                        <a href="javascript:void(0)" class="btn btn-xs btn-danger" data-toggle="tooltip" title="Delete"><i class="fa fa-trash"></i></a>
                                    </span>
                                </h4>
                            </div>
                        </div>
                    </div>
                    <!-- END Contact Widget -->

                    <?php } ?>
                </div>
                <!-- END Contacts Content -->
            </div>
            <!-- END Contacts Block -->
        </div>
        <div class="col-lg-4">
            <!-- Add Contact Block -->
            <div class="block">
                <!-- Add Contact Title -->
                <div class="block-title">
                    <h2><i class="fa fa-plus"></i> Add Privileges</h2>
                </div>
                <!-- END Add Contact Title -->

                <!-- Add Contact Content -->
                <form action="#" id="permission_form" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                    
                    <div class="form-group">
                        <label class="col-xs-3 control-label" for="add-contact-name">Permission Name</label>
                        <div class="col-xs-9">
                            <input type="text" id="category_name" name="permission" class="form-control" placeholder="Enter Permission Name.." required>
                        </div>
                    </div>
                    <div id="success_msg" class="text-success"></div>
                    <div id="danger_msg" class="text-danger"></div>
                    <div class="form-group form-actions">
                        <div class="col-xs-9 col-xs-offset-3">
                            <button type="submit" name="submit" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Privilege</button>
                        </div>
                    </div>
                </form>
                <!-- END Add Contact Content -->
            </div>
            <!-- END Add Contact Block -->
        </div>
    </div>
    <!-- END Main Row -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>
<?php include 'inc/template_end.php'; ?>
<script>
    $(document).ready(function(){
        $('#permission_form').submit(function(e){
            e.preventDefault();
            $.ajax({
                url: 'process_rights.php',
                method: 'POST',
                data: $(this).serialize(),
                success: function(resp) {
             
                    if(resp == 1) {
                        $('#success_msg').html('Permission added successfully.');
                        $('#permission_form').trigger("reset");
                        window.location.reload();
                    } else {
                        $('#danger_msg').html(resp);
                    } 
                   
                
                }
            })
        })
    })
</script>