<?php 
include 'inc/config.php';
include 'inc/template_start.php';
include 'inc/page_head.php'; 
include_once "functions.php";
?>

<!-- Page content -->
<div id="page-content">
    <!-- Inbox Header -->
    <div class="content-header">
        <div class="header-section">
            <h1><i class="gi gi-pencil"></i> Compose Message<br><small>Your Message Center</small></h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li>Message Center</li>
        <li><a href="">Compose Message</a></li>
    </ul>
    <!-- END Inbox Header -->

    <!-- Inbox Content -->
    <div class="row">
        <!-- Inbox Menu -->
        <div class="col-sm-4 col-lg-3">
            <!-- Menu Block -->
            <div class="block full">
                <!-- Menu Title -->
                <div class="block-title clearfix">
                    <div class="block-options pull-right">
                        <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Refresh"><i class="fa fa-refresh"></i></a>
                    </div>
                    <div class="block-options pull-left">
                        <a href="page_ready_inbox_compose.php" class="btn btn-alt btn-sm btn-default"><i class="fa fa-pencil"></i> Compose Message</a>
                    </div>
                </div>
                <!-- END Menu Title -->

                <!-- Menu Content -->
                <ul class="nav nav-pills nav-stacked">
                    <li>
                        <a href="#page_ready_inbox.php">
                            <span class="badge pull-right">5</span>
                            <i class="fa fa-angle-right fa-fw"></i> <strong>Sent</strong>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <i class="fa fa-angle-right fa-fw"></i> <strong>Trash</strong>
                        </a>
                    </li>
                </ul>
                <!-- END Menu Content -->
            </div>
            <!-- END Menu Block -->

            <!-- Tags Block -->
            <div class="block full">
                <!-- Tags Title -->
                <div class="block-title">
                <?php if(in_array('add_groups', $array) == true) { ?>
                    <div class="block-options pull-right">
                        <a href="javascript:void(0)" id="create_group" onclick="$('#modal-create-group').modal('show');" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Create Group"><i class="fa fa-plus"></i></a>
                    </div>
                <?php } ?>
                    <h2> <i class="fa fa-tags"></i> Groups <strong></strong></h2>
                </div>
                <!-- END Tags Title -->

                <!-- Tags Content -->
                <ul class="nav nav-pills nav-stacked">
                    <?php get_groups($connection, $array) ?>
                </ul>
                <!-- END Tags Content -->
            </div>
            <!-- END Tags Block -->

            <!-- Account Stats Block -->
            <div class="block">
                <!-- Account Status Title -->
                <div class="block-title">
                    <div class="block-options pull-right">
                        <span class="label label-warning">70%</span>
                    </div>
                    <h2><i class="fa fa-user"></i> Account <strong>Status</strong></h2>
                </div>
                <!-- END Account Status Title -->

                <!-- Account Stats Content -->
                <div class="row block-section text-center">
                    <div class="col-xs-12">
                        <div class="pie-chart block-section" data-percent="70" data-line-width="2" data-bar-color="#e67e22" data-track-color="#ffffff">
                            <img src="img/placeholders/avatars/avatar<?php echo rand(1, 16); ?>.jpg" alt="avatar" class="pie-avatar img-circle">
                        </div>
                    </div>
                </div>
                <table class="table table-borderless table-striped table-vcenter">
                    <tbody>
                        <tr>
                            <td class="text-right" style="width: 50%;"><strong>Active Plan</strong></td>
                            <td>Business <a href="page_ready_pricing_tables.php" data-toggle="tooltip" title="Upgrade to VIP"><i class="fa fa-arrow-up"></i></a></td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Credit Balance:</strong></td>
                            <td><span class="text-danger" id="credit_left"> </span></td>
                        </tr>
                        

                        <tr>
                            <td class="text-right"><strong style="font-size: small;">Top Up Wallet: Paybill</strong></td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Business Number:</strong></td>
                            <td class="text-warning"><strong style="font-size: larger;"> 4093753</strong> </td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Account Number:</strong></td>
                            <td class="text-warning"><strong style="font-size: larger;">canon</strong> </td>
                        </tr>
                    </tbody>
                </table>
                <!-- END Account Status Content -->
            </div>
            <!-- END Account Status Block -->

        </div>
        <!-- END Inbox Menu -->

        <!-- Compose Message List -->
        <div class="col-sm-8 col-lg-9">
            <!-- Compose Message Block -->
            <div class="block">
                <!-- Compose Message Title -->
                <div class="block-title">
                    <div class="block-options pull-right">
                        <a href="javascript:void(0)" id="cc-input-btn" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Send to Group"><i class="fa fa-plus"></i> Send to Group</a>
                        <!--<a href="javascript:void(0)" id="bcc-input-btn"  class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Show Bcc field"><i class="fa fa-plus"></i> Bcc</a> -->
                    </div>
                    <h2>Compose <strong>Message</strong></h2>
                </div>
                <!-- END Compose Message Title -->

                <!-- Compose Message Content -->
                <form action="" id="send_msg_form" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                    <small style="margin-left: 150px;" class="text-danger"><b>Separate Multiple Numbers using a comma(,) or Send to Group. Example: (25471234567,25474567271) </b></small>
                    <div class="form-group">
                        
                        <label class="col-md-3 col-lg-2 control-label" for="compose-to">To</label>
                        <div class="col-md-9 col-lg-10">
                            <input type="text" id="compose-to" name="sendto" class="form-control form-control-borderless" placeholder="Where to? Number Format(Example: 25741575274 or 741575274)">
                        </div>
                    </div>
                    <div id="cc-input" class="form-group display-none">
                        <label class="col-md-3 col-lg-2 control-label" for="compose-to-cc">Select Group</label>
                        <div class="col-md-9 col-lg-10">
                            <select name="group" id="compose-to-cc" class="form-control form-control-borderless">
                                <option value="">Select Group</option>
                                <?php
                                $sql = $connection -> query("SELECT * FROM `groups` ORDER BY group_name ASC");
                                while($row = $sql -> fetch_assoc()) {
                                    $group_id = $row['group_id'];
                                    $group_name = $row['group_name'];
                                    echo '
                                    <option value="'.$group_id.'">'.$group_name.'</option>
                                    ';
                                }
                                ?>
                            </select>
                            
                            <datalist id="group">
                               
                            </datalist>
                        </div>
                    </div>
                    <div id="bcc-input" class="form-group display-none">
                        <label class="col-md-3 col-lg-2 control-label" for="compose-to-bcc">Bcc</label>
                        <div class="col-md-9 col-lg-10">
                            <input type="email" id="compose-to-bcc" name="compose-to-bcc" class="form-control form-control-borderless" placeholder="Enter Bcc emails..">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 col-lg-2 control-label" for="compose-message">Message</label>
                        <div class="col-md-9 col-lg-10">
                            <textarea id="compose-message" name="message" rows="20" class="form-control" placeholder="Your message.." required></textarea>
                            <div class=""> <span id="count_c">0</span> / 145 Characters Max</div>
                        </div>
                        
                    </div>
                    <div class="form-group" id="loader_container">
                        <div class="loader"></div><i id="loading_msg">Sending, Please Wait...Don't Close the Browser.</i> <br> <br> <p><b>Note:</b> If you have a huge data, it might take sometime to process.</p>
                    </div>
                    <div id="progress-container" style="display: none; width: 100%; background: #ddd; border-radius: 5px;">
                        <div id="progress-bar" style="width: 0%; height: 30px; background: #28a745; text-align: center; color: white; line-height: 30px; border-radius: 5px;">0%</div>
                    </div>
                    <p id="time-left"></p>
                    <div class="form-group" id="error_success_msg">
                        <div style="max-width: 400px; max-height: 100px;overflow:auto" id="success_msg_container">
                            <h5>Mobile No# | Status</h5>
                            <p class="text-success" id="success_msg"> </p>
                        </div>

                        <div style="max-width: 400px; max-height: 100px;overflow:auto;" id="danger_msg_container">
                            <h5>Failed Number# | Error</h5>
                            <p class="text-danger" id="danger_msg"> </p>
                        </div>
                        <div class="testing" id="testing_box"></div>
                    </div>
                    <div class="form-group form-actions">
                        <div class="col-md-9 col-md-offset-3 col-lg-10 col-lg-offset-2">
                            <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-share"></i> Send</button>
                            <a href="delivery_view.php" class="btn btn-sm btn-default"><i class="fa fa-pencil"></i> View Delivery Report</a>
                        </div>
                    </div>
                </form>
                <!-- END Compose Message Content -->
            </div>
            <!-- END Compose Message Block -->
        </div>
        <!-- END Compose Message -->
    </div>
    <!-- END Inbox Content -->
</div>
<!--Modeal for creating a new group -->
<div id="modal-create-group" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Add Group</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="process_groups.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered">
                    <fieldset>
                        <legend>Group Info</legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Group Name</label>
                            <div class="col-md-8">
                                <input type="text" id="user-group-name" name="group_name" class="form-control" placeholder="Please Enter a Group Name.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-email">Contacts <i class="text-warning"> (Only .xls files are supported) </i> </label>
                            <div class="col-md-8">
                                <input type="file" name="file" id="contacts" accept=".xls" required>
                            </div>
                        </div>
                        
                    </fieldset>
                   
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-sm btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>

<!--Modal Content -->
<div id="modal-delete-password" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Enter Delete Password </h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="delete_group.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                   
                    <fieldset>
                        <legend>Password </legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Password</label>
                            <div class="col-md-8">
                                <input type="hidden" name="group_id" value="" id="group_id">
                                <input type="password" id="user-settings-password" name="password" class="form-control" placeholder="Please enter the delete password for verification" required>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Finish</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/readyInboxCompose.js"></script>
<script>$(function(){ ReadyInboxCompose.init(); });</script>
<script>
    $(document).ready(function(){
        $('#success_msg_container').hide();
        $('#danger_msg_container').hide();
        $('#loader_container').hide();
        

        $('#send_msg_form').submit(function(e) {
            e.preventDefault();
            $('#loader_container').show();
            $('#success_msg_container').hide();
            $('#danger_msg_container').hide();
            $('#progress-container').show();
            
            let xhr = new XMLHttpRequest();
            xhr.open("POST", "process_send_msg.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            
            xhr.onprogress = function() {
                let responseText = xhr.responseText.trim();
                let progressUpdates = responseText.split("\n"); // Handle multiple updates

                progressUpdates.forEach(update => {
                    try {
                        let data = JSON.parse(update);
                        updateProgress(data);
                    } catch (e) {
                        console.error("Error parsing progress update:", update);
                    }
                });
            };

            xhr.onload = function() {
                $('#progress-bar').css('width', '100%').text('100%'); // Ensure it reaches 100%
                $('#time-left').text('Completed!');
                $('#loader_container').hide();
            };

            xhr.send($('#send_msg_form').serialize());
        });

        function updateProgress(data) {
            let percent = Math.round((data.sent / data.total) * 100);
            $('#progress-bar').css('width', percent + '%').text(percent + '%');

            if (data.time_left) {
                let formattedTime = formatTime(data.time_left);
                $('#time-left').text('Estimated time left: ' + formattedTime);
            }
        }

        function formatTime(seconds) {
            let minutes = Math.floor(seconds / 60);
            let remainingSeconds = seconds % 60;
            
            if (minutes > 0) {
                return `${minutes} min ${remainingSeconds}s`;
            } else {
                return `${remainingSeconds}s`;
            }
        }




        //Delete group
        $(document).on('click', '#delete_group', function(e) {
            e.preventDefault();
            if(confirm('Are you sure you want to delete this group') == true) {
                var group_id = $(this).attr('data-id');
                document.getElementById("group_id").setAttribute('value', group_id);
                $('#modal-delete-password').modal('show');
                /*
                $.ajax({
                    url: 'delete_group.php',
                    method: 'POST',
                    data: {group_id: group_id},
                    success: function(resp) {
                        if(resp == 1) {
                            alert('Group deleted successfully.');
                            location.reload();
                        } else {
                            alert('Failed to delete group. Please try again!');
                        }
                    }
                })*/
            }
           
            
        })

   
    })

    //count message textarea
    function textLength(value){
        var maxLength = 145;
        if(value.length > maxLength) 
        return false;
        return true;
    }
    
    document.getElementById('compose-message').onkeyup = function(){
        if(!textLength(this.value)) {
            var count = this.value.length
            $('#count_c').text(count)
            document.getElementById("count_c").style.color = "red";
        } else {
            var count = this.value.length
            $('#count_c').text(count)
            document.getElementById("count_c").style.color = "grey";
        }
    }

    function refreshCredit() {
        $.ajax({
            url: 'credit_balance.php?_=' + new Date().getTime(), // Cache-buster added
            method: 'GET',
            cache: false,
            success: function(response) {
                $('#credit_left').html('<strong>' + response + '</strong> /-');
            },
            error: function() {
                $('#credit_left').html('<strong>Error</strong> /-');
            }
        });
    }

    // Refresh every second
    setInterval(refreshCredit, 1000);

    // Load credit immediately when the page loads
    refreshCredit();
</script>

<?php include 'inc/template_end.php'; ?>