<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; 
$protocol=$_SERVER['SERVER_PROTOCOL'];

if(strpos($protocol, "HTTPS"))
{
    $protocol="HTTPS://";
    echo $protocol;
}
else
{
    $protocol="HTTP://";   
}
$redirect_link_var=$protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

?>
<style> 
    * {
        font-size: 14px;
    }
    a {
        text-decoration: none;
    }

    #pagination{
        display: flex;
        flex-wrap: wrap;
    }
</style>

<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Products Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li>
                <a href="page_ecom_dashboard.php"><i class="fa fa-bar-chart"></i> Dashboard</a>
            </li>
            <li>
                <a href="page_ecom_orders.php"><i class="gi gi-shop_window"></i> Orders</a>
            </li>
            <li>
                <a href="page_ecom_order_view.php"><i class="gi gi-shopping_cart"></i> Order View</a>
            </li>
            <li class="active">
                <a href="page_ecom_products.php"><i class="gi gi-shopping_bag"></i> Products</a>
            </li>
            <li>
                <a href="page_ecom_product_edit.php"><i class="gi gi-pencil"></i> Product Edit</a>
            </li>
            <li>
                <a href="page_ecom_customer_view.php"><i class="gi gi-user"></i> Customer View</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Products Header -->

    <!-- Quick Stats -->
    <div class="row text-center">
        <div class="col-sm-6 col-lg-3">
            <a href="new_product.php" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-success">
                    <h4 class="widget-content-light"><strong>Add New</strong> Product</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 text-success animation-expandOpen"><i class="fa fa-plus"></i></span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-danger">
                    <h4 class="widget-content-light"><strong>Out of</strong> Stock</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 text-danger animation-expandOpen"><?php echo 0; ?></span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Top</strong> Sellers</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">20</span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>All</strong> Products</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen"><?php  ?></span></div>
            </a>
        </div>
    </div>
    <!-- END Quick Stats -->

    <!-- All Products Block -->
    <div class="block full">
        <!-- All Products Title -->
        <div class="block-title">
            <div class="block-options pull-right">
                <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Settings"><i class="fa fa-cog"></i></a>
            </div>
            <h2><strong>All</strong> Products</h2>
        </div>
        <!-- END All Products Title -->

        <!-- All Products Content -->
        <table id="ecom-products" class="table table-bordered table-striped table-vcenter">
            <div class="page_numbers">
                <ul class="text-decoration-none d-flex list-unstyled" id="pagination">
                    
                </ul>
            </div>
            <thead>
                <tr>
                    <th class="text-center" style="width: 70px;">ID</th>
                    <th>Product Name</th>
                    <th class="hidden-xs">Price</th>
                    <th class="hidden-xs">Product Code</th>
                    <th class="hidden-xs text-center">Publish Status</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody id="product_data">
              
            </tbody>
        </table>
        <!-- END All Products Content -->
    </div>
    <!-- END All Products Block -->
</div>
<!--Modal Content -->
<div id="modal-delete-product" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Enter Delete Password </h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="delete_product.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                   
                    <fieldset>
                        <legend>Password </legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Password</label>
                            <div class="col-md-8">
                                <?php
                                $url =  "//{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";

                                $escaped_url = htmlspecialchars( $url, ENT_QUOTES, 'UTF-8' );
                                ?>
                                <input type="hidden" name="url" value="<?php echo $escaped_url ?>">
                                <input type="hidden" name="product_id" value="" id="product_id">
                                <input type="password" id="user-settings-password" name="password" class="form-control" placeholder="Please enter the delete password for verification" required>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Finish</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END Page Content -->


<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/ecomProducts.js"></script>
<script>$(function(){ EcomProducts.init(); });</script>
<script>
   
    $(document).ready(function(){
        
        $(document.body).on('click', "#delete", function() {
            var showClick = document.querySelectorAll("#delete");
            
                for (var i = 0; i < showClick.length; i++) {
                    showClick[i].addEventListener('click', function(event) {
                        event.preventDefault();
                        var ready = confirm("Are you sure you want to delete this item?");
                        if(ready == true) {
                            var product_id = this.dataset.id;
                            
                            document.getElementById("product_id").setAttribute('value', product_id);
                            $('#modal-delete-product').modal('toggle');
                            
                           /*
                            $.ajax({
                                type: "post",
                                url: "delete_product.php",
                                data: {product_id: product_id},
                                success: function (response) {
                                    
                                    if(response == 1) {
                                        alert('Product Deleted successfully', 'success');
                                        window.location.reload();
                                    } else if(response == 2) {
                                        alert('Deleting product failed', 'danger');
                                    } else {
                                        alert(response, 'danger');
                                    }
                                
                                }
                            }); */
                        }
                    });
                
            }
           
        })

        var page = location.search.split('page=')[1]
        var url = "<?php echo $redirect_link_var ?>";
        if(page == undefined) {
            $('#product_data').load('load_products.php?url='+url);
            $('#pagination').load('pages.php');
        }
        if(page != null) {
            $('#product_data').load('load_products.php?page='+page+'&url='+url);
            $('#pagination').load('pages.php?page='+page);
        } 
        
    })
</script>
<?php include 'inc/template_end.php'; ?>