<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>
<?php


?>
<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Product Edit Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li>
                <a href="page_ecom_dashboard.php"><i class="fa fa-bar-chart"></i> Dashboard</a>
            </li>
            <li>
                <a href="page_ecom_orders.php"><i class="gi gi-shop_window"></i> Orders</a>
            </li>
            <li>
                <a href="page_ecom_order_view.php"><i class="gi gi-shopping_cart"></i> Order View</a>
            </li>
            <li>
                <a href="page_ecom_products.php"><i class="gi gi-shopping_bag"></i> Products</a>
            </li>
            <li class="active">
                <a href="page_ecom_product_edit.php"><i class="gi gi-pencil"></i> Product Edit</a>
            </li>
            <li>
                <a href="page_ecom_customer_view.php"><i class="gi gi-user"></i> Customer View</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Product Edit Header -->

    <!-- Product Edit Content -->
    <div class="row">
        <div class="col-lg-6">
            <!-- General Data Block -->
            <div class="block">
                <!-- General Data Title -->
                <div class="block-title">
                    <h2><i class="fa fa-pencil"></i> <strong>General</strong> Data</h2>
                </div>
                <!-- END General Data Title -->

                <!-- General Data Content -->
                <?php
                if(!empty($_GET['pid'])) {
                    $pid = $_GET['pid'];
                   
                }
                ?>
                <form action="add_product.php" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-id">PID</label>
                        <div class="col-md-9">
                            <input type="text" id="product-id" name="product_id" class="form-control" value="6825">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-name">Product Name</label>
                        <div class="col-md-9">
                            <input type="text" id="product-name" name="product_name" class="form-control" placeholder="Enter product name..">
                        </div>
                    </div>
        			<div class="form-group">
		        		<label class="col-md-3 control-label" for="brand_id">Brand Name</label>
                        <div class="col-md-8">
                            <select class="select-chosen" name="brand_id" style="width: 250px;">
                                <option value="">Select Brand</option>
                                <?php
                                $jk = "SELECT * FROM brands";
                                $q1 = mysqli_query($connection, $jk);
                                while($rows = mysqli_fetch_assoc($q1)) {
                                    $brand_id = $rows['brand_id'];
                                    $brand_title = $rows['brand_title'];
                                    echo '
                                    <option value="'.$brand_id.'">'.$brand_title.'</option>
                                    ';
                                }
                                ?>
                                    
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
		        		<label class="col-md-3 control-label" for="category_id">Category</label>
                        <div class="col-md-8">
                            <select class="select-chosen" name="category_id" style="width: 250px;">
                                <option value="">Select Category</option>
                                <?php
                                $jc = "SELECT * FROM categories";
                                $q1 = mysqli_query($connection, $jc);
                                while($rows = mysqli_fetch_assoc($q1)) {
                                    $cat_id = $rows['cat_id'];
                                    $cat_title = $rows['cat_title'];
                                    echo '
                                    <option value="'.$cat_id.'">'.$cat_title.'</option>
                                    ';
                                }
                                ?>
                            </select>
                        </div>
                        </div>
                    
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product_description">Description</label>
                        <div class="col-md-9">
                            <!-- CKEditor, you just need to include the plugin (see at the bottom of this page) and add the class 'ckeditor' to your textarea -->
                            <!-- More info can be found at http://ckeditor.com -->
                            <textarea id="product-description" name="product_desc" class="ckeditor"></textarea>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-short-description">Short Description</label>
                        <div class="col-md-9">
                            <textarea id="product-short-description"  class="ckeditor" name="product_short_description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-price">Price</label>
                        <div class="col-md-8">
                            <div class="input-group">
                                <div class="input-group-addon"><i class="fa fa-usd"></i></div>
                                <input type="text" id="product-price" name="product_price" class="form-control" placeholder="0,00">
                            </div>
                        </div>
                    </div>
                    <!--
                    <div class="col-12">
                        <div class="form-group">
                            <label class="col-md-3 control-label">Storage Variation</label>
                                <button class="btn_variation" id ="true"> Open Variation </button>
                                <button class="btn_variation" id = "false"> Close </button>
                        </div>
                    </div>
                        <div class="col-12" id="storage_variation">
                            <div class="form-group" >
                                <label style="color: green;">Storage 1</label>
                                <select name="storage1" id="" class="form-control">
                                    <option value="0">Please Select Storage</option>
                                    <option value="8GB"> 8GB </option>
                                    <option value="16GB"> 16GB </option>
                                    <option value="32GB"> 32GB </option>
                                    <option value="64GB"> 64GB </option>
                                    <option value="128GB"> 128GB </option>
                                    <option value="256GB"> 256GB </option>
                                    <option value="512GB"> 512GB </option>
                                    <option value="1TB"> 1TB </option>
                                    </select>
                                    <br>
                                <input type="text" name="storage1_price" class="form-control" placeholder="Enter Price for Storage 1">
                            </div>
                        
                        <div class="form-group">
                            <label style="color: green;">Storage 2</label>
                            <select name="storage2" id="" class="form-control">
                                <option value="0">Please Select Storage</option>
                                <option value="8GB"> 8GB </option>
                                <option value="16GB"> 16GB </option>
                                <option value="32GB"> 32GB </option>
                                <option value="64GB"> 64GB </option>
                                <option value="128GB"> 128GB </option>
                                <option value="256GB"> 256GB </option>
                                <option value="512GB"> 512GB </option>
                                <option value="1TB"> 1TB </option>
                                </select>
                                <br>
                                <input type="text" name="storage2_price" class="form-control" placeholder="Enter Price for Storage 2">
                        </div>

                        <div class="form-group">
                            <label style="color: green;">Storage 3</label>
                            <select name="storage3" id="" class="form-control">
                                <option value="0">Please Select Storage</option>
                                <option value="8GB"> 8GB </option>
                                <option value="16GB"> 16GB </option>
                                <option value="32GB"> 32GB </option>
                                <option value="64GB"> 64GB </option>
                                <option value="128GB"> 128GB </option>
                                <option value="256GB"> 256GB </option>
                                <option value="512GB"> 512GB </option>
                                <option value="1TB"> 1TB </option>
                            </select>
                                <br>
                            <input type="text" name="storage3_price" class="form-control" placeholder="Enter Price for Storage 3">
                        </div>


                    </div>-->

                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-qty">Product Quantity</label>
                        <div class="col-md-9">
                            <input type="text" id="product_qty" name="product_qty" class="form-control" placeholder="Enter product qty..">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label">Condition</label>
                        <div class="col-md-9">
                            <label class="radio-inline" for="product-condition-new">
                                <input type="radio" id="product-condition-new" name="product_condition" value="new" checked> New
                            </label>
                            <label class="radio-inline" for="product-condition-used">
                                <input type="radio" id="product-condition-used" name="product_condition" value="used"> Used
                            </label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Publish?</label>
                        <div class="col-md-9">
                            <label class="switch switch-primary">
                                <input type="checkbox" id="product-status" name="product_status" checked><span></span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group form-actions">
                        <div class="col-md-9 col-md-offset-3">
                            <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-floppy-o"></i> Save</button>
                            <button type="reset" class="btn btn-sm btn-warning"><i class="fa fa-repeat"></i> Reset</button>
                        </div>
                    </div>
                
                <!-- END General Data Content -->
            </div>
            <!-- END General Data Block -->
        </div>
        <div class="col-lg-6">
            <!-- Meta Data Block -->
            <div class="block">
                <!-- Meta Data Title -->
                <div class="block-title">
                    <h2><i class="fa fa-google"></i> <strong>Meta</strong> Data</h2>
                </div>
                <!-- END Meta Data Title -->

                <!-- Meta Data Content -->
                <div class="form-horizontal form-bordered">
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-title">Meta Title</label>
                        <div class="col-md-9">
                            <input type="text" id="meta_title" name="meta_title" class="form-control" placeholder="Enter meta title..">
                            <div class="help-block"> <span id="count_c">0</span> / 60 Characters Max</div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-keywords">Meta Keywords</label>
                        <div class="col-md-9">
                            <input type="text" id="product-meta-keywords" name="meta_keywords" class="form-control" placeholder="keyword1, keyword2, keyword3">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-description">Meta Description</label>
                        <div class="col-md-9">
                            <textarea name="meta_description" id="meta_desc" class="form-control" rows="6" placeholder="Enter meta description.."></textarea>
                            <div class="help-block"><span id="count_d">0</span> / 150 Characters Max</div>
                        </div>
                    </div>
                    <div class="form-group form-actions">
                        
                    </div>
                </div>
                <!-- END Meta Data Content -->
            </div>
            </form>
            <!-- END Meta Data Block -->

            <!-- Product Images Block -->
            <div class="block">
                <!-- Product Images Title -->
                <div class="block-title">
                    <h2><i class="fa fa-picture-o"></i> <strong>Product</strong> Images</h2>
                </div>
                <!-- END Product Images Title -->

                <!-- Product Images Content -->
                <div class="block-section">
                    <!-- Dropzone.js, You can check out https://github.com/enyo/dropzone/wiki for usage examples -->
                    <form action="process_image.php" class="dropzone"></form>
                </div>
                <table id="load_images" class="table table-bordered table-striped table-vcenter">
                    <tbody >
                    <?php
                        $userid = $_SESSION['uid']; // Ensure this is set
                        $all_files = glob("uploads/" . $userid . "/*.*");

                        if ($all_files) {
                            for ($i = 0; $i < count($all_files); $i++) {
                                $image_name = $all_files[$i];

                                $supported_format = array('gif', 'jpg', 'jpeg', 'png', 'jfif', 'webp');
                                $ext = strtolower(pathinfo($image_name, PATHINFO_EXTENSION));
                                if (in_array($ext, $supported_format)) {
                                    echo '
                                        <tr>
                                            <td>
                                                <a href="' . htmlspecialchars($image_name) . '" data-toggle="lightbox-image">
                                                    <img src="' . htmlspecialchars($image_name) . '" alt="' . htmlspecialchars($image_name) . '" class="img-responsive center-block" style="max-width: 110px;">
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                <label class="switch switch-primary">
                                                    <input type="checkbox"><span></span>
                                                </label>
                                                Publish
                                            </td>
                                            <td class="text-center">
                                                <a href="javascript:void(0)" id="delete_image" data-id="' . htmlspecialchars($image_name) . '" class="btn btn-xs btn-danger"><i class="fa fa-trash-o"></i> Delete</a>
                                            </td>
                                        </tr>';
                                }
                            }
                        }
                        ?>

                       
                    </tbody>
                </table>
                <!-- END Product Images Content -->
            </div>
            <!-- END Product Images Block -->
        </div>
    </div>
    <!-- END Product Edit Content -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- ckeditor.js, load it only in the page you would like to use CKEditor (it's a heavy plugin to include it with the others!) -->
<script src="js/helpers/ckeditor/ckeditor.js"></script>
<script>
    setInterval(
    function(){
        $('#load_images').load(' #load_images');
    },1000);

      $(document).ready(function() {
            $('#storage_variation').hide()
            $("#false").click(function(e){
                e.preventDefault()
               $("#storage_variation").toggle(false);
            });

            $("#true").click(function(e){
              e.preventDefault()
               $("#storage_variation").toggle(true);
            });

            //refresh div
            //setTimeout(function() { $("#load_images").reload(1000); }, 1000)

            

            $(document).on('click', '#delete_image', function() { 
                var product_id = $(this).attr('data-id');
                
                $.ajax({
                    type: "post",
                    url: "delete_image.php",
                    data: {product_id: product_id},
                    success: function (response) {
                        
                        if(response == 1) {
                            toastr.info('Image Deleted successfully', 'success');
                        } else if(response == 2) {
                            toastr.info('Deleting image failed', 'danger');
                        } else {
                            toastr.info(response, 'danger');
                        }
                     
                    }
                });
            })

            //count meta title
            function textLength(value){
                var maxLength = 60;
                if(value.length > maxLength) 
                return false;
                return true;
            }
            
            document.getElementById('meta_title').onkeyup = function(){
                if(!textLength(this.value)) {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "red";
                } else {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "grey";
                }
            }
            
            
            //count meta description
            CKEDITOR.replace('product-description', {
                allowedContent: true
            });

            CKEDITOR.replace('product-short-description', {
                allowedContent: true
            });

            var editor = CKEDITOR.replace( 'meta_desc', {});
            editor.on( "pluginsLoaded", function( event ){
                editor.on( 'contentDom', function( evt ) {
                    var editable = editor.editable();                   
                    editable.attachListener( editable, 'keyup', function( e ) { 
                        // do something
                        
                        var size = editor.getData().replace(/<[^>]*>/g, '').replace(/\s+/g, ' ').replace(/&\w+;/g ,'X').replace(/^\s*/g, '').replace(/\s*$/g, '').length;
                        if(size > 150) {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "red";
                        } else {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "grey";
                        }
                    });
                }); 
            });
        })
</script>
<?php include 'inc/template_end.php'; ?>