<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>

<!-- Page content -->
<div id="page-content">
    <!-- Contacts Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
                <i class="gi gi-parents"></i>Category<br><small>Manage all your categories!</small>
            </h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li><a href="">Category</a></li>
    </ul>
<?php
include_once "inc/dbconn.php"; 

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid category ID");
}
$cat_id = intval($_GET['id']);

// Fetch current categorys
$stmt = $connection->prepare("SELECT * FROM categories WHERE cat_id = ?");
$stmt->bind_param("i", $cat_id);
$stmt->execute();
$result = $stmt->get_result();
$category = $result->fetch_assoc();
$stmt->close();

if (!$category) {
    die("Category not found.");
}

// If form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_title = trim($_POST['cat_title']);

    // Handle file upload if provided
    $new_image = $category['cat_image']; // default to old image
    if (!empty($_FILES['cat_image']['name'])) {
        $allowed_exts = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        $ext = strtolower(pathinfo($_FILES['cat_image']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, $allowed_exts)) {
            $fileName = uniqid("cat_", true) . "." . $ext;
            $uploadPath = __DIR__ . "/../cat_images/" . $fileName;

            if (move_uploaded_file($_FILES['cat_image']['tmp_name'], $uploadPath)) {
                // Delete old image if exists
                if (!empty($category['cat_image']) && file_exists(__DIR__ . "/../cat_images/" . $category['cat_image'])) {
                    unlink(__DIR__ . "/../cat_images/" . $category['cat_image']);
                }
                $new_image = $fileName;
            } else {
                echo "<script>alert('Failed to upload image');</script>";
            }
        } else {
            echo "<script>alert('Invalid image format. Allowed: jpg, jpeg, png, gif, webp');</script>";
        }
    }

    // Update DB
    $stmt = $connection->prepare("UPDATE categories SET cat_title = ?, cat_image = ? WHERE cat_id = ?");
    $stmt->bind_param("ssi", $new_title, $new_image, $cat_id);
    if ($stmt->execute()) {
        echo "<script>alert('Category updated successfully');window.location.href='categories.php';</script>";
    } else {
        echo "<script>alert('Error updating category');</script>";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Category</title>
</head>
<body>
    <h2>Edit Category</h2>
    <form method="POST" enctype="multipart/form-data">
        <label>Category Name:</label><br>
        <input type="text" name="cat_title" value="<?php echo htmlspecialchars($category['cat_title']); ?>" required><br><br>

        <label>Current Image:</label><br>
        <img src="../cat_images/<?php echo htmlspecialchars($category['cat_image']); ?>" width="100"><br><br>

        <label>Upload New Image:</label><br>
        <input type="file" name="cat_image"><br><br>

        <button type="submit">Update</button>
    </form>
</body>
</html>
