<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>
<?php


?>
<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Product Edit Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li>
                <a href="page_ecom_dashboard.php"><i class="fa fa-bar-chart"></i> Dashboard</a>
            </li>
            <li>
                <a href="page_ecom_orders.php"><i class="gi gi-shop_window"></i> Orders</a>
            </li>
            <li>
                <a href="page_ecom_order_view.php"><i class="gi gi-shopping_cart"></i> Order View</a>
            </li>
            <li>
                <a href="page_ecom_products.php"><i class="gi gi-shopping_bag"></i> Products</a>
            </li>
            <li class="active">
                <a href="blog.php" ><i class="gi gi-user"></i> Blog</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Product Edit Header -->

    <!-- Product Edit Content -->
    <div class="row">
        <div class="col-lg-6">
            <!-- General Data Block -->
            <div class="block">
                <!-- General Data Title -->
                <div class="block-title">
                    <h2><i class="fa fa-pencil"></i> <strong>General</strong> Data</h2>
                </div>
                <!-- END General Data Title -->

                <!-- General Data Content -->
                <?php
                if(!empty($_GET['pid'])) {
                    $pid = $_GET['pid'];
                   
                }
                $categories = mysqli_query($connection, "SELECT id, category_name FROM blog_categories ORDER BY category_name ASC");

                ?>
                <form action="add_blog.php" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                   
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-name">Blog Title</label>
                        <div class="col-md-9">
                            <input type="text" id="product-name" name="blog_title" class="form-control" placeholder="Enter Blog Title..">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label" for="category">Category</label>
                        <div class="col-md-9">
                            <select name="category_id" id="category" class="form-control" required>
                                <option value="">-- Select a Category --</option>
                                <?php while ($cat = mysqli_fetch_assoc($categories)): ?>
                                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['category_name']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-name">Author</label>
                        <div class="col-md-9">
                            <input type="text" id="author" name="author" class="form-control" placeholder="Authors name e.g John ">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product_description">Story</label>
                        <div class="col-md-9">
                            <!-- CKEditor, you just need to include the plugin (see at the bottom of this page) and add the class 'ckeditor' to your textarea -->
                            <!-- More info can be found at http://ckeditor.com -->
                            <textarea id="product-description" name="blog" class="ckeditor"></textarea>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-md-3 control-label">Publish?</label>
                        <div class="col-md-9">
                            <label class="switch switch-primary">
                                <input type="checkbox" id="product-status" name="publish_status" checked><span></span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group form-actions">
                        <div class="col-md-9 col-md-offset-3">
                            <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-floppy-o"></i> Save</button>
                            <button type="reset" class="btn btn-sm btn-warning"><i class="fa fa-repeat"></i> Reset</button>
                        </div>
                    </div>
                
                <!-- END General Data Content -->
            </div>
            <!-- END General Data Block -->
        </div>
        <div class="col-lg-6">
            <!-- Meta Data Block -->
            <div class="block">
                <!-- Meta Data Title -->
                <div class="block-title">
                    <h2><i class="fa fa-google"></i> <strong>Meta</strong> Data</h2>
                </div>
                <!-- END Meta Data Title -->

                <!-- Meta Data Content -->
                <div class="form-horizontal form-bordered">
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-title">Meta Title</label>
                        <div class="col-md-9">
                            <input type="text" id="meta_title" name="meta_title" class="form-control" placeholder="Enter meta title..">
                            <div class="help-block"> <span id="count_c">0</span> / 60 Characters Max</div>
                        </div>
                    </div>
                    <!--
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-keywords">Meta Keywords</label>
                        <div class="col-md-9">
                            <input type="text" id="product-meta-keywords" name="meta_keywords" class="form-control" placeholder="keyword1, keyword2, keyword3">
                        </div>
                    </div>-->
                    <div class="form-group">
                        <label class="col-md-3 control-label" for="product-meta-description">Meta Description</label>
                        <div class="col-md-9">
                            <textarea name="meta_description" id="meta_desc" class="form-control" rows="6" placeholder="Enter meta description.."></textarea>
                            <div class="help-block"><span id="count_d">0</span> / 150 Characters Max</div>
                        </div>
                    </div>
                    <div class="form-group form-actions">
                        
                    </div>
                </div>
                <!-- END Meta Data Content -->
            </div>
            </form>
            <!-- END Meta Data Block -->

            <!-- Product Images Block -->
            <div class="block">
                <!-- Product Images Title -->
                <div class="block-title">
                    <h2><i class="fa fa-picture-o"></i> <strong>Blog</strong> Images</h2>
                </div>
                <!-- END Product Images Title -->

                <!-- Product Images Content -->
                <div class="block-section">
                    <!-- Dropzone.js, You can check out https://github.com/enyo/dropzone/wiki for usage examples -->
                    <form action="process_image.php" class="dropzone"></form>
                </div>
                <table id="load_images" class="table table-bordered table-striped table-vcenter">
                    <tbody >
                        <?php
                            $all_files = glob("uploads/".$user_id."/*.*");
                            for ($i=0; $i<count($all_files); $i++)
                            {
                                $image_name = $all_files[$i];
                                $supported_format = array('gif','jpg','jpeg','png','jfif');
                                $ext = strtolower(pathinfo($image_name, PATHINFO_EXTENSION));
                                if (in_array($ext, $supported_format)){
                                    echo '
                                        <tr>
                                            <td>
                                                <a href="'.$image_name.'" data-toggle="lightbox-image">
                                                    <img src="'.$image_name.'" alt="'.$image_name.'" class="img-responsive center-block" style="max-width: 110px;">
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                <label class="switch switch-primary">
                                                    <input type="checkbox"><span></span>
                                                </label>
                                                Publish
                                            </td>
                                            <td class="text-center">
                                                <a href="javascript:void(0)" id="delete_image" data-id="'.$image_name.'" dat class="btn btn-xs btn-danger"><i class="fa fa-trash-o"></i> Delete</a>
                                            </td>
                                        </tr> 
                                    ';
                                    //echo '<img src="'.$image_name .'" alt="'.$image_name.'" />'."<br /><br />";
                                } else {
                                     continue;
                                }
                            }

                        ?>
                       
                    </tbody>
                </table>
                <!-- END Product Images Content -->
            </div>
            <!-- END Product Images Block -->
        </div>
    </div>
    <!-- END Product Edit Content -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- ckeditor.js, load it only in the page you would like to use CKEditor (it's a heavy plugin to include it with the others!) -->
<script src="js/helpers/ckeditor/ckeditor.js"></script>
<script>
      $(document).ready(function() {
            $('#storage_variation').hide()
            $("#false").click(function(e){
                e.preventDefault()
               $("#storage_variation").toggle(false);
            });

            $("#true").click(function(e){
              e.preventDefault()
               $("#storage_variation").toggle(true);
            });

            //refresh div
            //setTimeout(function() { $("#load_images").reload(1000); }, 1000)

            setInterval(
            function(){
                $('#load_images').load(' #load_images');
            },1000);

            $(document).on('click', '#delete_image', function() { 
                var product_id = $(this).attr('data-id');
                
                $.ajax({
                    type: "post",
                    url: "delete_image.php",
                    data: {product_id: product_id},
                    success: function (response) {
                        
                        if(response == 1) {
                            toastr.info('Image Deleted successfully', 'success');
                        } else if(response == 2) {
                            toastr.info('Deleting image failed', 'danger');
                        } else {
                            toastr.info(response, 'danger');
                        }
                     
                    }
                });
            })

            //count meta title
            function textLength(value){
                var maxLength = 60;
                if(value.length > maxLength) 
                return false;
                return true;
            }
            
            document.getElementById('meta_title').onkeyup = function(){
                if(!textLength(this.value)) {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "red";
                } else {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "grey";
                }
            }

            //count meta description
            var editor = CKEDITOR.replace( 'meta_desc', {});
            editor.on( "pluginsLoaded", function( event ){
                editor.on( 'contentDom', function( evt ) {
                    var editable = editor.editable();                   
                    editable.attachListener( editable, 'keyup', function( e ) { 
                        // do something
                        
                        var size = editor.getData().replace(/<[^>]*>/g, '').replace(/\s+/g, ' ').replace(/&\w+;/g ,'X').replace(/^\s*/g, '').replace(/\s*$/g, '').length;
                        if(size > 150) {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "red";
                        } else {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "grey";
                        }
                    });
                }); 
            });
        })
</script>
<?php include 'inc/template_end.php'; ?>