<?php
include_once 'inc/navigation.php';
?>

        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span> Blog</span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- cart page content -->
        <div class="blog-page-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9">
                        <div class="single-blog page-content blog-page blog-sidebar right-sidebar">
                            <!-- blog post -->
                            <?php
                            try {
                                $slug = $_GET['slug'] ?? ''; // Example: single-blog.php?slug=my-post
                                $stmt = $pdo->prepare("SELECT * FROM blog WHERE slug = ? AND publish_status = '1' LIMIT 1");
                                $stmt->execute([$slug]);
                                $blog = $stmt->fetch(PDO::FETCH_ASSOC);

                                if (!$blog) {
                                    echo "<p>Blog post not found.</p>";
                                    exit;
                                }
                            } catch (PDOException $e) {
                                echo "<p>Error loading blog: " . htmlspecialchars($e->getMessage()) . "</p>";
                                exit;
                            }

                            // --- Load Blog Content ---
                            $blogPath = "blog/" . trim($blog['blog']);
                            $content = '';
                            if (file_exists($blogPath)) {
                                $content = file_get_contents($blogPath);
                            } else {
                                $content = "Content unavailable.";
                            }

                            // --- Prepare Images ---
                            $images = array_filter(array_map('trim', explode(',', $blog['blog_image'])));
                            shuffle($images); // Randomize image order

                            // --- Inject Random Images into Content ---
                            $paragraphs = preg_split('/(\r\n|\n|\r)/', $content);
                            $totalImages = count($images);
                            $imageIndex = 0;

                            // Insert an image randomly after every few paragraphs
                            foreach ($paragraphs as $i => &$p) {
                                $p = trim($p);
                                if ($p !== '' && $imageIndex < $totalImages && rand(1, 3) === 2) {
                                    $img = htmlspecialchars($images[$imageIndex]);
                                    $p .= '<div class="post-thumbnail my-3 text-center">
                                            <img src="blog_images/' . $img . '" alt="' . htmlspecialchars($blog['blog_title']) . '" class="img-fluid rounded">
                                        </div>';
                                    $imageIndex++;
                                }
                            }
                            $content = implode('<p>', array_map('nl2br', $paragraphs));

                            // --- Prepare tags ---
                            $tags = array_filter(array_map('trim', explode(',', $blog['tags'])));
                            ?>

                            <article class="text-center">
                                <div class="blog-entry-header">
                                    <div class="post-category">
                                        <a href="#"><?php echo htmlspecialchars($blog['meta_title']); ?></a>
                                    </div>
                                    <h1><a href="#"><?php echo htmlspecialchars($blog['blog_title']); ?></a></h1>
                                    <div class="post-meta">
                                        <a href="#" class="post-author"><i class="fa fa-user"></i> Posted by <?php echo htmlspecialchars($blog['author']); ?></a>
                                        <a href="#" class="post-date"><i class="fa fa-calendar"></i> <?php echo date("F j, Y", strtotime($blog['date'])); ?></a>
                                    </div>
                                </div>

                                <div class="post-thumbnail">
                                    <?php if (!empty($images)): ?>
                                        <a href="#"><img src="blog_images/<?php echo htmlspecialchars($images[0]); ?>" alt="<?php echo htmlspecialchars($blog['blog_title']); ?>" class="img-responsive"></a>
                                    <?php endif; ?>
                                </div>

                                <div class="postinfo-wrapper">
                                    <?php echo $content; ?>

                                    <div class="single-post-tag mt-4">
                                        <a class="comment-link" href="#">0 comments</a> / Tags:
                                        <?php foreach ($tags as $tag): ?>
                                            <a href="#" rel="tag"><?php echo htmlspecialchars($tag); ?></a><?php if (next($tags)) echo ','; ?>
                                        <?php endforeach; ?>
                                    </div>

                                    <div class="social-sharing mt-4">
                                        <h3>Share this post</h3>
                                        <div class="social-sharie">
                                            <ul class="social-icons">
                                                <li><a class="facebook social-icon" id="share-facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                <li><a class="twitter social-icon" id="share-twitter" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                                <li><a class="pinterest social-icon" id="share-pinterest" target="_blank"><i class="fa fa-pinterest"></i></a></li>
                                                <li><a class="linkedin social-icon" id="share-linkedin" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                                <li><a class="email social-icon" id="share-email"><i class="fa fa-envelope"></i></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </article>

                            <!-- blog post end -->
                            <div class="relatedposts">
                               <h3>Related posts</h3>
                                <div class="row">
                                <?php
                                try {
                                    // Get related posts based on same category, excluding current post
                                    $stmt = $pdo->prepare("
                                        SELECT blog_title, slug, blog_image, date 
                                        FROM blog 
                                        WHERE category_id = ? AND slug != ? AND publish_status = '1'
                                        ORDER BY date DESC 
                                        LIMIT 3
                                    ");
                                    $stmt->execute([$blog['category_id'], $blog['slug']]);
                                    $relatedPosts = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                } catch (PDOException $e) {
                                    echo "<p>Error loading related posts: " . htmlspecialchars($e->getMessage()) . "</p>";
                                    $relatedPosts = [];
                                }

                                if ($relatedPosts) {
                                    foreach ($relatedPosts as $post) {
                                        // Handle image (take first from list)
                                        $images = array_filter(array_map('trim', explode(',', $post['blog_image'])));
                                        $image = !empty($images[0]) ? htmlspecialchars($images[0]) : 'default.webp';
                                        ?>
                                        <!-- related post -->
                                        <div class="relatedthumb col-md-4 col-sm-6 mb-3">
                                            <div class="image">
                                                <a href="single-blog.php?slug=<?php echo htmlspecialchars($post['slug']); ?>">
                                                    <img src="blog_images/<?php echo $image; ?>" 
                                                        alt="<?php echo htmlspecialchars($post['blog_title']); ?>" 
                                                        class="img-fluid rounded">
                                                </a>
                                            </div>
                                            <h4 class="mt-2">
                                                <a rel="external" href="single-blog.php?slug=<?php echo htmlspecialchars($post['slug']); ?>">
                                                    <?php echo htmlspecialchars($post['blog_title']); ?>
                                                </a>
                                            </h4>
                                            <span class="post-date"><?php echo date('F j, Y', strtotime($post['date'])); ?></span>
                                        </div>
                                        <!-- related post end -->
                                        <?php
                                    }
                                } else {
                                    echo '<p class="text-muted">No related posts available.</p>';
                                }
                                ?>
                                </div>

                            </div>
                        </div>
                        <div class="comments-area">
                                <?php
                                $postId = $blog['id'];

                                try {
                                    // Total comments count
                                    $countStmt = $pdo->prepare("SELECT COUNT(*) FROM comments WHERE post_id = ?");
                                    $countStmt->execute([$postId]);
                                    $totalComments = $countStmt->fetchColumn();

                                    // Load first 3
                                    $stmt = $pdo->prepare("SELECT * FROM comments WHERE post_id = ? ORDER BY created_at ASC LIMIT 3");
                                    $stmt->execute([$postId]);
                                    $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                } catch (PDOException $e) {
                                    echo "<p>Error loading comments: " . htmlspecialchars($e->getMessage()) . "</p>";
                                    $comments = [];
                                    $totalComments = 0;
                                }
                                ?>

                                <h3><?php echo $totalComments; ?> <?php echo $totalComments === 1 ? 'Comment' : 'Comments'; ?></h3>

                                <ol class="commentlist" id="commentList">
                                    <?php foreach ($comments as $comment): ?>
                                        <?php
                                        $emailHash = md5(strtolower(trim($comment['email'])));
                                        $avatarUrl = "https://www.gravatar.com/avatar/$emailHash?d=identicon&s=100";
                                        ?>
                                        <li>
                                            <div class="single-comment">
                                                <div class="comment-avatar">
                                                    <img src="<?php echo $avatarUrl; ?>" alt="avatar">
                                                </div>
                                                <div class="comment-info">
                                                    <a href="#"><?php echo htmlspecialchars($comment['name']); ?></a>
                                                    <span class="date"><?php echo date("F j, Y \\a\\t g:i a", strtotime($comment['created_at'])); ?></span>
                                                    <p><?php echo nl2br(htmlspecialchars($comment['message'])); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ol>

                                <?php if ($totalComments > 3): ?>
                                    <div class="text-center mt-3">
                                        <button id="loadMoreComments" 
                                            class="btn btn-outline-primary px-4 py-2" 
                                            data-post-id="<?php echo $postId; ?>" 
                                            data-offset="3">
                                            Load More
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>


                        <div class="comment-respond">
                            <h3>💬 Leave a Reply</h3>
                            <small>Your email address will not be published. Required fields are marked *</small>

                            <form id="commentForm">
                                <input type="hidden" id="post_id" name="post_id" value="<?php echo htmlspecialchars($blog['id']); ?>">

                                <div class="text-filds">
                                    <label for="comment">Comment</label>
                                    <textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required="required"></textarea>
                                </div>

                                <div class="comment-input">
                                    <p class="comment-form-author">
                                        <label for="author">Name <span class="required">*</span></label>
                                        <input id="author" name="author" type="text" size="30" maxlength="245" required="required">
                                    </p>
                                    <p class="comment-form-email">
                                        <label for="email">Email <span class="required">*</span></label>
                                        <input id="email" name="email" type="email" size="30" maxlength="100" aria-describedby="email-notes" required="required">
                                    </p>
                                </div>
                                    <br> <br> <br> <br>
                                <div class="form-submit">
                                    <button type="submit" id="submit" class="submit">
                                        <span id="submitText">Post Comment</span>
                                        <span id="spinner" class="spinner-border spinner-border-sm d-none"></span>
                                    </button>
                                </div>
                            </form>
                        </div>

                    </div>
                    <div class="col-lg-3">
                        <div class="blog_sidebar">
                            <div class="row_products_side">
                                <div class="product_left_sidbar">
                                    <div class="product-filter  mb-30">
                                        <h5>Search </h5>
                                        <div class="search__sidbar">
                                            <div class="input_form">
                                            <input type="text" id="search_input" name="s" value="Search..." class="input_text">
                                            <button id="blogsearchsubmit" type="submit" class="button">
                                                <i class="fa fa-search"></i>
                                            </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="product-filter  mb-30">
                                        <h5>Categories</h5>
                                        <div class="blog_Archives__sidbar">
                                            <ul>
                                                <?php
                                                try {
                                                    // Fetch categories with post counts
                                                    $stmt = $pdo->query("
                                                        SELECT c.id, c.category_name, COUNT(b.id) AS post_count
                                                        FROM blog_categories c
                                                        LEFT JOIN blog b ON b.category_id = c.id AND b.publish_status = '1'
                                                        GROUP BY c.id
                                                        ORDER BY post_count DESC, c.category_name ASC
                                                    ");

                                                    if ($stmt->rowCount() > 0) {
                                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $categoryName = htmlspecialchars($row['category_name']);
                                                            $count = (int)$row['post_count'];

                                                            echo "
                                                                <li>
                                                                    <a href='blog.php?category={$row['id']}'>{$categoryName}</a>&nbsp;({$count})
                                                                </li>
                                                            ";
                                                        }
                                                    } else {
                                                        echo "<li>No categories available yet.</li>";
                                                    }
                                                } catch (PDOException $e) {
                                                    echo "<li>Error fetching categories: " . htmlspecialchars($e->getMessage()) . "</li>";
                                                }
                                                ?>
                                            </ul>
                                        </div>

                                    </div>
                                    <div class="product-filter  mb-30">
                                       <h5>Recent Posts</h5>
                                        <div class="blog_Archives__sidbar">
                                            <ul>
                                                <?php
                                                // Fetch the 5 most recent published blogs
                                                $stmt = $pdo->query("
                                                    SELECT 
                                                        b.id, 
                                                        b.blog_title, 
                                                        b.slug, 
                                                        (SELECT COUNT(*) FROM comments c WHERE c.post_id = b.id) AS comment_count
                                                    FROM blog b
                                                    WHERE b.publish_status = '1'
                                                    ORDER BY b.date DESC
                                                    LIMIT 5
                                                ");

                                                if ($stmt->rowCount() > 0) {
                                                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                        $title = htmlspecialchars($row['blog_title']);
                                                        $slug = htmlspecialchars($row['slug']);
                                                        $count = (int)$row['comment_count'];
                                                        echo "
                                                            <li>
                                                                <a href='blog/{$slug}.php'>{$title}</a>&nbsp;({$count})
                                                            </li>
                                                        ";
                                                    }
                                                } else {
                                                    echo "<li>No recent posts available.</li>";
                                                }
                                                ?>
                                            </ul>
                                        </div>

                                    </div>
                                    <div class="sidebar-single-banner">
                                        <a href="#">
                                            <img src="assets/images/banner/shop-sidebar.webp" alt="Banner">
                                        </a>
                                    </div>
                                    <div class="product-filter mb-30">
                                        <h5>Product Tags</h5>
                                        <div class="blog-tags">
                                            <a href="#">J-beauty</a>
                                            <a href="#">skincare</a>
                                            <a href="#">moisturizer</a>
                                            <a href="#">serum</a>
                                            <a href="#">facial mask</a>
                                            <a href="#">sunscreen</a>
                                            <a href="#">natural extracts</a>
                                            <a href="#">anti-aging</a>
                                            <a href="#">glowing skin</a>
                                            <a href="#">beauty routine</a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- cart page content end -->

<?php
include_once 'inc/footer.php';
?>
<script src="js/action/load_more_comments.js"></script>
<script src="js/blog/comment_form.js"></script>