let currentPage = 1;
let category = "<?php echo $_GET['cat'] ?? ''; ?>";
let brand = "<?php echo $_GET['brand'] ?? ''; ?>";
let search = "<?php echo $_GET['q'] ?? ''; ?>";

function loadProducts(page = 1) {
    $.ajax({
        url: "api/products/fetch_shop_products.php",
        type: "GET",
        data: {
            page: page,
            category: category,
            brand: brand,
            search: search,
            sort: $("#sort_by").val()
        },
        beforeSend: function() {
            $("#product-container").html('<div class="text-center w-100 p-4">Loading...</div>');
        },
        success: function(response) {
            $("#product-container").html(response.products);
            $("#pagination").html(response.pagination);
            $("html, body").animate({ scrollTop: $("#grid").offset().top - 100 }, "slow");
            currentPage = page;
        }
    });
}

// handle sorting
$("#sort_by").change(function() {
    loadProducts(1);
});

// pagination click
$(document).on("click", ".page-link", function(e) {
    e.preventDefault();
    let page = $(this).data("page");
    if (page) loadProducts(page);
});

$(document).ready(function() {
    loadProducts();
});