$(document).on('click', '#loadMoreComments', function() {
    const btn = $(this);
    const postId = btn.data('post-id');
    const offset = parseInt(btn.data('offset'));

    console.log('%c[LoadMore Triggered]', 'color: #0af; font-weight: bold;');
    console.log('Post ID:', postId);
    console.log('Current Offset:', offset);

    btn.prop('disabled', true).text('Loading...');

    $.ajax({
        url: 'api/action/load_more_comments.php',
        type: 'POST',
        dataType: 'json',
        data: { post_id: postId, offset: offset },
        beforeSend: function() {
            console.log('%c[AJAX Request Sending...]', 'color: #999;');
        },
        success: function(response) {
            console.log('%c[AJAX Response Received]', 'color: #0c0;');
            console.log('Raw Response:', response);

            if (response.status === 'success' && response.comments.length > 0) {
                console.log(`Adding ${response.comments.length} comments to list...`);

                response.comments.forEach((comment, index) => {
                    console.log(`→ Comment #${index + 1}:`, comment);

                    const avatar = `https://www.gravatar.com/avatar/${md5(comment.email.trim().toLowerCase())}?d=identicon&s=100`;
                    $('#commentList').append(`
                        <li>
                            <div class="single-comment">
                                <div class="comment-avatar">
                                    <img src="${avatar}" alt="avatar">
                                </div>
                                <div class="comment-info">
                                    <a href="#">${comment.name}</a>
                                    <span class="date">${new Date(comment.created_at).toLocaleString()}</span>
                                    <p>${comment.message.replace(/\n/g, '<br>')}</p>
                                </div>
                            </div>
                        </li>
                    `);
                });

                btn.data('offset', offset + 3);
                console.log('Updated Offset:', btn.data('offset'));

                if (response.comments.length < 3) {
                    console.log('%cNo more comments to load. Hiding button.', 'color: #f80;');
                    btn.hide();
                }
            } else {
                console.warn('%cNo comments returned or response not success.', 'color: #f33;');
                btn.hide();
            }
        },
        error: function(xhr, status, error) {
            console.error('%c[AJAX Error]', 'color: #f00; font-weight: bold;');
            console.error('XHR:', xhr.responseText);
            console.error('Status:', status);
            console.error('Error:', error);
            toastr.error("Failed to load more comments.");
        },
        complete: function() {
            console.log('%c[AJAX Complete]', 'color: #0af;');
            btn.prop('disabled', false).text('Load More');
        }
    });
});
