<?php
include_once 'inc/navigation.php';
?>
        <!-- Slider area -->
        <div class="slider-area">
            <!-- slider start -->
            <div class="slider-inner">
                <div id="mainSlider" class="nivoSlider nevo-slider">
                    <img src="images/new_images/banner_6.webp" alt="<?= $site_name ?>" title="#htmlcaption1" loading="lazy"/>
                    <img src="images/new_images/banner_1.webp" alt="<?= $site_name ?>" title="#htmlcaption2" loading="lazy"/>
                </div>

                <!-- Overlay covering the entire slider -->
                <div class="slider-overlay"></div>

                <!-- Captions -->
                <div id="htmlcaption1" class="nivo-html-caption slider-caption">
                    <div class="slider-content slider-content-1">
                        <p class="hp1 text-white">It has finally arrived...</p>
                        <h1 class="hone text-white">Pure beauty from</h1>
                        <h2 class="htwo text-white">Japan to Kenya</h2> 
                        <div class="button-1 hover-btn-2 text-white">
                            <a href="#">SHOP NOW</a>
                        </div>
                    </div>
                </div>

                <div id="htmlcaption2" class="nivo-html-caption slider-caption">
                    <div class="slider-content slider-content-2">
                        <p class="hp1 text-dark">It has finally arrived...</p>
                        <h1 class="hone text-dark">New serum with</h1>
                        <h2 class="htwo text-dark">Stem cell power</h2> 
                        <div class="button-1 hover-btn-2">
                            <a href="#">SHOP NOW</a>
                        </div>
                    </div>
                </div>
            </div>


            <style>
               /* Overlay that covers the whole slider */
                .slider-inner {
                    position: relative; /* make overlay absolute relative to slider */
                }

                .slider-overlay {
                    position: absolute;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0,0,0,0.35); /* adjust darkness */
                    z-index: 1;
                }

                /* Keep captions on top */
                .nivo-html-caption .slider-content {
                    position: relative;
                    z-index: 2;
                    color: #fff;
                    text-shadow: 2px 2px 8px rgba(0,0,0,0.6);
                    
                }


            </style>
            <!-- slider end -->
        </div>
        <!-- Slider area end -->

        <!-- Policy area -->
        <div class="policy-area">
            <div class="container">
                <div class="policy-area-inner">
                    <div class="row">
                        <div class="col-sm-6 col-md-6 col-lg-3">
                            <div class="single-policy">
                                <div class="icon"><i class=" fa fa-truck"></i></div>
                                <div class="txt_cms">
                                    <h2>Free Shipping</h2>
                                    <p>Free shipping on all order</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6 col-lg-3">
                            <div class="single-policy">
                                <div class="icon"><i class=" fa fa-credit-card"></i></div>
                                <div class="txt_cms">
                                    <h2>Money Guarantee</h2>
                                    <p>30 days money back</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6 col-lg-3">
                            <div class="single-policy">
                                <div class="icon"><i class=" fa fa-question-circle"></i></div>
                                <div class="txt_cms">
                                    <h2>Online Support</h2>
                                    <p>online 24/24 on day</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6 col-lg-3">
                            <div class="single-policy">
                                <div class="icon"><i class=" fa fa-sun-o"></i></div>
                                <div class="txt_cms">
                                    <h2>Secure Payment</h2>
                                    <p>100% secure payment</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>   
        <!-- Policy area end -->

        <!-- poslistcategories -->
        <div class="poslistcategories">
            <div class="container">
               <div class="pos_title_categories">
                    <h2>Popular <span>Categories</span> Today</h2>
                    <p>Discover our most loved skincare essentials — from deep hydration to daily protection.  
                    Thoughtfully made in Japan, perfected for Kenyan skin.</p>
                </div>


                <div class="row pos_content">
                    <div class="block_content owl-carousel">
                        <!-- single item -->
                       <?php
                        try {
                            $stmt = $pdo->prepare("SELECT * FROM categories ORDER BY date DESC LIMIT 2");
                            $stmt->execute();
                            $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        } catch (PDOException $e) {
                            echo "<p>Error fetching categories: " . htmlspecialchars($e->getMessage()) . "</p>";
                            $categories = [];
                        }

                        if (!empty($categories)) {
                            foreach ($categories as $cat) { 
                        ?>
                                <div class="list-categories">
                                    <div class="box-inner">
                                        <div class="category-thumb-circle">
                                            <a href="shop.php?category=<?php echo $cat['cat_id']; ?>">
                                                <img src="cat_images/<?php echo htmlspecialchars($cat['cat_image']); ?>" 
                                                    alt="<?php echo htmlspecialchars($cat['cat_title']); ?>">
                                            </a>
                                        </div>


                                        <div class="desc-listcategoreis">
                                            <h3 class="name_categories">
                                                <a href="shop.php?category=<?php echo $cat['cat_id']; ?>">
                                                    <?php echo htmlspecialchars($cat['cat_title']); ?>
                                                </a>
                                            </h3>
                                            <div class="listcate_shop_now">
                                                <a href="shop.php?category=<?php echo $cat['cat_id']; ?>">Shop Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <style>
                                .category-thumb-circle {
                                    width: 300px;        /* fix the size */
                                    height: 300px;
                                    border-radius: 50%;  /* force circle */
                                    overflow: hidden;    /* clip any overflowing content */
                                    display: flex;
                                    justify-content: center;
                                    align-items: center;
                                    margin: auto;        /* optional, center */
                                    box-shadow: 0 4px 8px rgba(0,0,0,0.2); /* optional nice shadow */
                                }

                                .category-thumb-circle img {
                                    width: 100%;
                                    height: 100%;
                                    object-fit: cover;   /* make sure it fills the container without stretching */
                                }

                                </style>
                                
                        <?php
                            }
                        } else {
                            echo "<p>No categories available at the moment.</p>";
                        }
                        ?>

                        <!-- single item end -->
                    </div>
                </div>
            </div>
        </div>
        <!-- poslistcategories end -->

        <!-- home banner -->
        <div class="home-banner">
            <div class="container-fluid p-0">
                <div class="row g-0">
                    <div class="col-md-6">
                        <div class="banner-box m-0">
                            <a href="shop.php">
                                <img src="images/new_images/products_banner.webp" alt="<?= $site_name ?>" loading="lazy"></a>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="banner-box m-0">
                            <a href="shop.php">
                                <img src="images/new_images/small_banner.webp" alt="<?= $site_name ?>" loading="lazy"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- home banner end -->

        <!-- product tabs container slider -->
        <div class="product-tabs-container-slider product_block_container">
            <div class="container">                
                <div id="content">
                    <?php
                    function getProductsByType($pdo, $typeCondition, $limit = 8) {
                        try {
                            $stmt = $pdo->prepare("SELECT * FROM products WHERE product_status='on' AND $typeCondition ORDER BY date DESC LIMIT :limit");
                            $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
                            $stmt->execute();
                            return $stmt->fetchAll(PDO::FETCH_ASSOC);
                        } catch (PDOException $e) {
                            echo "<p>Error fetching products: " . htmlspecialchars($e->getMessage()) . "</p>";
                            return [];
                        }
                    }

                    // Fetch product groups
                    $newArrivalProducts = getProductsByType($pdo, "new='no'");
                    $bestSellerProducts = getProductsByType($pdo, "production_status=3");
                    $featuredProducts   = getProductsByType($pdo, "production_status=0");

                    function renderProducts($products) {
                        if (empty($products)) {
                            echo "<p>No products found.</p>";
                            return;
                        }

                        foreach ($products as $product) {
                            $images = explode(',', $product['product_image']);
                            $mainImage = trim($images[0]);
                            $discount = 0;

                            if (!empty($product['old_price']) && $product['old_price'] > 0) {
                                $discount = round((($product['old_price'] - $product['product_price']) / $product['old_price']) * 100);
                            }
                    ?>
                        <div class="item-product">
                            <div class="product-miniature js-product-miniature">
                                <div class="img_block">
                                    <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>" class="thumbnail product-thumbnail">
                                        <img src="product_images/<?php echo htmlspecialchars($mainImage); ?>" alt="<?php echo htmlspecialchars($product['product_title']); ?>">
                                    </a>
                                    <ul class="product-flag">
                                        <?php if ($product['new'] == 'yes') { ?><li class="new"><span>New</span></li><?php } ?>
                                    </ul>
                                   <div class="quick-view">
                                        <a href="#" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#product_modal" 
                                        data-id="<?php echo $product['product_id']; ?>" 
                                        class="quick_view" 
                                        data-original-title="Quick View">
                                        <i class="fa fa-search"></i>
                                        </a>
                                    </div>

                                    <div class="hook-reviews">
                                        <div class="comments_note">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </div>
                                    </div>
                                    <?php if ($discount > 0) { ?>
                                        <div class="product-price-and-shipping_top">
                                            <span class="discount-percentage discount-product">-<?php echo $discount; ?>%</span>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="product_desc">
                                    <div class="manufacturer">
                                        <a href="shop.php">WITHOUT by FAITH</a>
                                    </div>
                                    <h1>
                                        <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>" class="product_name" title="<?php echo htmlspecialchars($product['product_title']); ?>">
                                            <?php echo htmlspecialchars($product['product_title']); ?>
                                        </a>
                                    </h1>
                                    <div class="product-price-and-shipping">
                                        <?php if (!empty($product['old_price']) && $product['old_price'] > 0) { ?>
                                            <span class="regular-price">Ksh <?php echo number_format($product['old_price']); ?></span>
                                        <?php } ?>
                                        <span class="price price-sale">Ksh <?php echo number_format($product['product_price']); ?></span>
                                    </div>
                                    <div class="cart">
                                        <div class="product-add-to-cart">
                                            <a href="#" class="add-to-cart-btn" data-id="<?php echo $product['product_id']; ?>">
                                                <span class="btn-text">Add to cart</span>
                                                <span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                        }
                    }
                    ?>

                    <!-- Tabs -->
                    <ul id="tabs" class="nav tabs_slider" data-bs-tabs="tabs">
                        <!--<li ><a href="#newarrival" data-bs-toggle="tab">New Arrival</a></li>
                        <li><a href="#bestseller" data-bs-toggle="tab">Bestseller</a></li> -->
                        <li class="active"> <a href="#featuredproducts" data-bs-toggle="tab">Featured Products</a></li>
                    </ul>

                    <div class="pos_content">
                        <div id="my-tab-content" class="tab-content">
                            <!-- New Arrival -->
                            <div class="tab-pane fade " id="newarrival">
                                <div class="productTabContent0 owl-carousel">
                                    <?php renderProducts($newArrivalProducts); ?>
                                </div>
                            </div>

                            <!-- Bestseller -->
                            <div class="tab-pane fade" id="bestseller">
                                <div class="productTabContent0 owl-carousel">
                                    <?php renderProducts($bestSellerProducts); ?>
                                </div>
                            </div>

                            <!-- Featured -->
                            <div class="tab-pane fade show active" id="featuredproducts">
                                <div class="productTabContent0 owl-carousel">
                                    <?php renderProducts($featuredProducts); ?>
                                </div>
                            </div>
                        </div>
                    </div>

            </div>
        </div>
        <!-- product tabs container slider end -->
        
        <!-- static product -->
        <div class="static_product">
            <div class="container">
                <div class="row">
                    <?php

                    try {
                        $stmt = $pdo->prepare("SELECT * FROM products WHERE product_status='on' ORDER BY RAND() LIMIT 3");
                        $stmt->execute();
                        $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    } catch (PDOException $e) {
                        echo "<p>Error fetching products: " . htmlspecialchars($e->getMessage()) . "</p>";
                        $products = [];
                    }
                    ?>

                    <div class="row">
                        <?php foreach ($products as $product) { 
                            // Handle images
                            $images = explode(',', $product['product_image']);
                            $mainImage = trim($images[0]) ?: 'default.webp';

                            // Handle description text file
                            $desc = 'W.Kirei Beauty'; // Default description

                            if (!empty($product['product_desc'])) {
                                $descPath = 'description/' . trim($product['product_desc']);
                                if (file_exists($descPath)) {
                                    $descContent = file_get_contents($descPath);
                                    $desc = mb_substr(strip_tags($descContent), 0, 100) . '...';
                                }
                            }


                            // Optional sale text
                            $saleText = '';
                            if (!empty($product['old_price']) && $product['old_price'] > 0) {
                                $discount = round((($product['old_price'] - $product['product_price']) / $product['old_price']) * 100);
                                if ($discount > 0) $saleText = "Sale {$discount}% off";
                            }
                        ?>
                            <div class="col-lg-4 col-md-6">
                                <div class="item-static">
                                    <div class="banner-box">
                                        <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>">
                                            <img src="product_images/<?php echo htmlspecialchars($mainImage); ?>" alt="<?php echo htmlspecialchars($product['product_title']); ?>" class="img-responsive" style="width:auto;height:300px;object-fit:cover;">
                                        </a>
                                    </div>
                                    <div class="content-static">
                                        <?php if ($saleText) { ?>
                                            <div class="sale-static"><?php echo $saleText; ?></div>
                                        <?php } ?>
                                        <h2><?php echo htmlspecialchars($product['product_title']); ?></h2>
                                        <p><?php echo htmlspecialchars($desc); ?></p>
                                        <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                </div>
            </div>
        </div>
        <!-- static product -->

        <!-- testimonials container -->
        <div class="testimonials_container">
            <div class="container">
                <div class="block-content pos_content">
                    <div class="testimonialsSlide owl-carousel">
                        <div class="item-testimonials">
                            <div class="item">
                                <div class="content_author">
                                    <img src="assets/images/testimonials/sample1.webp" alt="Customer Testimonial - Nairobi, Kenya">
                                    <div class="content_test">
                                        <div class="des_testimonial">
                                            "I never knew my skin could feel this smooth and hydrated. The Japanese skincare quality is unmatched!"
                                        </div>
                                        <p class="des_namepost"><span>Nairobi, Kenya</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- testimonial iteme end -->

                        <!-- testimonial iteme -->
                        <div class="item-testimonials">
                            <div class="item">
                                <div class="content_author">
                                    <img src="assets/images/testimonials/sample2.webp" alt="Customer Testimonial - Mombasa, Kenya">
                                    <div class="content_test">
                                        <div class="des_testimonial">
                                            "Finally, a product that’s gentle, additive-free, and really works in our heat and humidity."
                                        </div>
                                        <p class="des_namepost"><span>Mombasa, Kenya</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- testimonial iteme end -->
                    </div>
                </div>
            </div>
        </div>
        <!-- testimonials container end -->

        <style>
            .product-flag li.christmas span {
                background: linear-gradient(135deg, #d32f2f, #c2185b);
                color: #fff;
                font-weight: 600;
                border-radius: 6px;
                padding: 4px 8px;
                font-size: 13px;
                position: relative;
                box-shadow: 0 0 12px rgba(211, 47, 47, 0.5);
                animation: glow 1.5s infinite alternate;
            }

            @keyframes glow {
                from { box-shadow: 0 0 6px rgba(211, 47, 47, 0.5); }
                to { box-shadow: 0 0 18px rgba(255, 82, 82, 0.9); }
            }

            .img_block {
                position: relative;
                overflow: hidden;
                border-radius: 10px;
                background: #f9f9f9;
                display: flex;
                align-items: center;
                justify-content: center;
                height: 250px; /* consistent height */
            }

            .img_block img {
                max-height: 100%;
                max-width: 100%;
                width: auto;
                height: auto;
                object-fit: contain;
                transition: transform 0.4s ease;
            }

            .img_block:hover img {
                transform: scale(1.05);
            }


        </style>
        <!-- pos special products  -->
        <div class="pos-special-products">
            <div class="container">
                <div class="special-products">
                    <div class="pos_title"><h2>Daily Deals</h2></div>
                    <div class="pos_content">
                        <div class="special-item owl-carousel">
                            <!-- special item -->
                          <?php
                            try {
                                // Prioritize products that have a deal_type value (non-empty), then sort by date
                                $stmt = $pdo->prepare("
                                    SELECT * FROM products 
                                    WHERE product_status = 'on' 
                                    ORDER BY 
                                        CASE WHEN deal_type IS NOT NULL AND deal_type != '' THEN 0 ELSE 1 END,
                                        date DESC 
                                    LIMIT 6
                                ");
                                $stmt->execute();
                                $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            } catch (PDOException $e) {
                                die('Database error: ' . $e->getMessage());
                            }

                            foreach ($products as $product):
                                // Extract first image (comma-separated list)
                                $images = explode(',', $product['product_image']);
                                $first_image = isset($images[0]) && !empty($images[0])
                                    ? trim($images[0])
                                    : 'assets/images/product/default.webp';

                                // Handle old price visibility
                                $show_old_price = ($product['old_price'] > 0);

                                // Countdown timer
                                $has_countdown = !empty($product['deal_end_date']);
                                $countdown_date = $has_countdown ? $product['deal_end_date'] : '';

                                // Detect special deal type (Christmas, Easter, etc.)
                                $deal_type = isset($product['deal_type']) ? strtolower(trim($product['deal_type'])) : '';
                            ?>
                                <div class="product-miniature js-product-miniature">
                                    <h1>
                                        <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>" 
                                        class="product_name" 
                                        title="<?php echo htmlspecialchars($product['product_title']); ?>">
                                        <?php echo htmlspecialchars($product['product_title']); ?>
                                        </a>
                                    </h1>

                                    <div class="img_block">
                                        <a href="product.php?slug=<?php echo htmlspecialchars($product['slug']); ?>" 
                                        class="thumbnail product-thumbnail">
                                            <img src="product_images/<?php echo htmlspecialchars($first_image); ?>" 
                                                alt="<?php echo htmlspecialchars($product['product_title']); ?>">
                                        </a>

                                        <ul class="product-flag">
                                            <?php if ($product['new'] === 'yes'): ?>
                                                <li class="new"><span>New</span></li>
                                            <?php endif; ?>

                                            <?php if (!empty($deal_type)): ?>
                                                <li class="christmas"><span>🎉 <?php echo ucfirst($deal_type); ?> Offer</span></li>
                                            <?php endif; ?>
                                        </ul>

                                        <div class="quick-view">
                                            <a href="#" data-bs-toggle="modal" 
                                            data-bs-target="#product_modal"  
                                            data-original-title="Quick View" 
                                            class="quick_view"
                                            data-id="<?php echo $product['product_id']; ?>">
                                            <i class="fa fa-search"></i>
                                            </a>
                                        </div>

                                        <div class="hook-reviews">
                                            <div class="comments_note">
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                            </div>
                                        </div>

                                        <?php if ($show_old_price): ?>
                                        <div class="product-price-and-shipping_top">
                                            <span class="discount-percentage discount-product">
                                                -<?php echo round((($product['old_price'] - $product['product_price']) / $product['old_price']) * 100); ?>%
                                            </span>
                                        </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="product_desc">
                                        <div class="manufacturer">
                                            <a href="shop.php?brand=<?php echo $product['product_brand']; ?>">Studio Design</a>
                                        </div>
                                        <div class="product-desc">
                                            <p><span><?php echo substr($product['product_short_description'], 0, 80); ?>...</span></p>
                                        </div>
                                        <div class="product-price-and-shipping">
                                            <?php if ($show_old_price): ?>
                                                <span class="regular-price">KSh <?php echo number_format($product['old_price']); ?></span>
                                            <?php endif; ?>
                                            <span class="price price-sale">KSh <?php echo number_format($product['product_price']); ?></span>
                                        </div>
                                        <div class="cart">
                                            <div class="product-add-to-cart">
                                                <a href="#" class="add-to-cart-btn" data-id="<?php echo $product['product_id']; ?>">Add to cart</a>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($has_countdown): ?>
                                    <div class="countdown">
                                        <div class="time_count_down">
                                            <div data-countdown="<?php echo htmlspecialchars($countdown_date); ?>"></div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>


                            <!-- special item end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- pos special products  end -->

        <div class="home_blog_post_area general product_block_container">
            <div class="home_blog_post">
                <div class="container">
                    <div class="page_title_area pos_title">
                        <h2><a href="#">Latest Blog Posts</a></h2>
                        <h3>Insights <span>That Inspire</span> You</h3>
                        <p>Stay ahead with our latest stories, trends, and expert tips on tech, innovation, and modern living — curated just for you.</p>
                    </div>

                    <div class="home_blog_post_inner">
                        <div class="blog_slider owl-carousel">
                            <!-- single blog item -->
                            <?php
                            try {
                                // Fetch only published blogs, latest first
                                $stmt = $pdo->prepare("SELECT * FROM blog WHERE publish_status = '1' ORDER BY date DESC LIMIT 6");
                                $stmt->execute();
                                $blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            } catch (PDOException $e) {
                                die("Database error: " . $e->getMessage());
                            }

                            foreach ($blogs as $blog):
                                // Handle comma-separated images
                                $images = explode(',', $blog['blog_image']);
                                $first_image = isset($images[0]) ? trim($images[0]) : 'default.webp';
                                
                                // Format date
                                $date = new DateTime($blog['date']);
                                $month = $date->format('M');
                                $day = $date->format('d');
                                $full_date = $date->format('M d, Y');
                            ?>
                                <div class="item">
                                    <div class="blog_post">
                                        <div class="post_thumbnail">
                                            <a href="single-blog.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>" class="img_content">
                                                <img src="blog_images/<?php echo htmlspecialchars($first_image); ?>" alt="<?php echo htmlspecialchars($blog['blog_title']); ?>" class="img-fluid" loading="lazy">
                                            </a>
                                            <a href="single-blog.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>" class="read-more">Read More</a>
                                        </div>
                                        <div class="post_content">
                                            <div class="date_time">
                                                <span class="moth_time"><?php echo htmlspecialchars($month); ?></span>
                                                <span class="day_time"><?php echo htmlspecialchars($day); ?></span>
                                            </div>
                                            <div class="content-inner">
                                                <h4 class="post_title">
                                                   
                                                    <a href="single-blog.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>" class="text-white">
                                                        <?php echo $blog['blog_title']; ?> 
                                                    </a>
                                                </h4>
                                                <div class="post_meta">
                                                    <span class="meta_date">
                                                        <i class="fa fa-calendar"></i>
                                                        <?php echo htmlspecialchars($full_date); ?>
                                                    </span> /
                                                    <span class="meta_author">
                                                        <i class="fa fa-user"></i>
                                                        <?php echo htmlspecialchars($blog['author']); ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                            <!-- single blog item end -->
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
        
<?php
include_once 'inc/footer.php';
?>



