<?php
header('Content-Type: application/json');
require '../../inc/dbconn.php'; // make sure $pdo is defined here

function response($status, $message) {
    echo json_encode(['status'=>$status,'message'=>$message]);
    exit;
}

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if(empty($username) || empty($password)) {
    response('error', 'All fields are required.');
}

try {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = :user OR email = :user LIMIT 1");
    $stmt->execute(['user' => $username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if(!$user || !password_verify($password, $user['password'])) {
        response('error', 'Invalid username/email or password.');
    }

    if($user['status'] !== 'success') {
        response('error', 'Your account is inactive or blocked.');
    }

    // Set session
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['username'] = $user['username'];

    response('success', 'Logged in successfully.');

} catch(PDOException $e) {
    response('error', 'Database error: ' . $e->getMessage());
}
?>
