<?php
include '../../inc/dbconn.php';
require '../../../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

try {
    $post_id = $_POST['post_id'] ?? '';
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $message = trim($_POST['message'] ?? '');

    if (!$post_id || !$name || !$email || !$message) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit;
    }

    // Save comment
    $stmt = $pdo->prepare("INSERT INTO comments (post_id, name, email, message) VALUES (?, ?, ?, ?)");
    $stmt->execute([$post_id, $name, $email, $message]);

    // Send thank-you email
    /*
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'mail.smartphonecity.ke';
    $mail->SMTPAuth = true;
    $mail->Username = 'sales@smartphonecity.ke';
    $mail->Password = 'njirainicanon.m';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    $mail->setFrom('sales@smartphonecity.ke', 'W.Kirei Blog');
    $mail->addAddress($email, $name);

    $mail->isHTML(true);
    $mail->Subject = "Thank you for your comment, $name!";
    $mail->Body = "
        <h2>Thank You for Your Comment 💬</h2>
        <p>We appreciate you taking the time to share your thoughts on our post.</p>
        <p>We'll review your comment and make it live shortly if it meets our community guidelines.</p>
        <br>
        <p>– The W.Kirei Team</p>
    ";
    $mail->AltBody = "Thank you for your comment, $name! We appreciate your feedback.";
    $mail->SMTPDebug = 2;
    $mail->Debugoutput = 'error_log';
    $mail->send();
    */

    echo json_encode(['status' => 'success', 'message' => 'Comment submitted successfully!']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Mailer Error: ' . $mail->ErrorInfo]);
}
