<?php
require_once 'inc/dbconn.php';
session_start();
$userid = $_SESSION['uid'];
$directory = 'uploads/' . $userid . '/';

if (!is_dir($directory)) {
    // Create the directory for the user if it doesn't exist
    mkdir($directory, 0770, true);
}

$ds = DIRECTORY_SEPARATOR; // Directory separator

if (!empty($_FILES)) {
    // Handle file upload
    $tempFile = $_FILES['file']['tmp_name'];          // Temporary file
    $originalFileName = $_FILES['file']['name'];      // Original file name
    $fileNameWithoutExt = pathinfo($originalFileName, PATHINFO_FILENAME); // File name without extension

    $targetPath = dirname(__FILE__) . $ds . $directory; // Target path
    $targetFile = $targetPath . $originalFileName;      // Full target file path

    // Move the uploaded file to the user-specific directory
    if (move_uploaded_file($tempFile, $targetFile)) {
        echo "File uploaded successfully.<br>";

        // Convert to WebP
        $webpFile = $targetPath . $fileNameWithoutExt . '.webp'; // WebP file path

        // Create an image resource from the uploaded file
        $imageResource = imagecreatefromstring(file_get_contents($targetFile));

        if ($imageResource) {
            // Convert palette images to truecolor if necessary
            if (!imageistruecolor($imageResource)) {
                $truecolorImage = imagecreatetruecolor(imagesx($imageResource), imagesy($imageResource));
                imagecopy($truecolorImage, $imageResource, 0, 0, 0, 0, imagesx($imageResource), imagesy($imageResource));
                imagedestroy($imageResource); // Free the original resource
                $imageResource = $truecolorImage;
            }

            // Save as WebP with quality 100
            if (imagewebp($imageResource, $webpFile, 100)) {
                echo "Image successfully converted to WebP.<br>";
                echo "<a href='$directory" . basename($webpFile) . "'>Download WebP Image</a>";

                // Delete the original uploaded file
                unlink($targetFile);
            } else {
                echo "Failed to convert image to WebP.<br>";
            }

            // Free resources
            imagedestroy($imageResource);
        } else {
            echo "Failed to process the image.<br>";
        }
    } else {
        echo "Failed to upload the file.<br>";
    }
}
?>
