<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>

<!-- Page content -->
<div id="page-content">
    <!-- Contacts Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
                <i class="gi gi-parents"></i>Partners<br><small>Manage all your partners!</small>
            </h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li><a href="">Partners</a></li>
    </ul>
    <!-- END Contacts Header -->

    <!-- Main Row -->
    <div class="row">
        <div class="col-lg-8">
            <!-- Contacts Block -->
            <div class="block">
                <!-- Contacts Title -->
                <div class="block-title">
                    <div class="block-options text-center">
                    </div>
                </div>
                <!-- END Contacts Title -->

                <!-- Contacts Content -->
             <div class="row style-alt">
                <?php 
                $get = $connection->query("SELECT * FROM partners");
                while ($row = $get->fetch_assoc()) {
                ?>
                <!-- Partner Widget -->
                <div class="col-sm-6 col-lg-4">
                    <div class="widget">
                        <div class="widget-simple">
                            <a href="<?php echo htmlspecialchars($row['website_url']); ?>" target="_blank" rel="noopener">
                                <img src="../partner_logos/<?php echo htmlspecialchars($row['logo']); ?>" 
                                    alt="Partner Logo" 
                                    class="widget-image img-circle pull-left animation-fadeIn" 
                                    style="width: 64px; height: 64px; object-fit: contain;">
                            </a>
                            <h4 class="widget-content text-right">
                                <a href="<?php echo htmlspecialchars($row['website_url']); ?>" target="_blank" rel="noopener">
                                    <strong><?php echo htmlspecialchars($row['name']); ?></strong>
                                </a><br>
                                <span class="btn-group">
                                    <a href="edit_partner.php?id=<?php echo $row['id']; ?>" class="btn btn-xs btn-primary" data-toggle="tooltip" title="Edit">
                                        <i class="fa fa-pencil"></i>
                                    </a>
                                </span>
                            </h4>
                        </div>
                    </div>
                </div>
                <!-- END Partner Widget -->
                <?php } ?>
            </div>

                <!-- END Contacts Content -->
            </div>
            <!-- END Contacts Block -->
        </div>
        <div class="col-lg-4">
            <!-- Add Contact Block -->
            <div class="block">
                <!-- Add Contact Title -->
                <div class="block-title">
                    <h2><i class="fa fa-plus"></i> Add Partner</h2>
                </div>
                <!-- END Add Contact Title -->

                <!-- Add Contact Content -->
                <form action="process_partner.php" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                    <div class="form-group">
                        <label class="col-xs-3 control-label text-muted">NO AVATAR</label>
                        <div class="col-xs-9">
                            <i class="fa fa-fw fa-upload"></i> Upload New Avatar
                            <input type="file" name="logo" id="logo" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-xs-3 control-label" for="name">Partner Name</label>
                        <div class="col-xs-9">
                            <input type="text" id="name" name="name" class="form-control" placeholder="Enter Partner Name.." required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-xs-3 control-label" for="website_url">Website URL</label>
                        <div class="col-xs-9">
                            <input type="url" id="website_url" name="website_url" class="form-control" placeholder="https://partner-website.com" required>
                        </div>
                    </div>

                    <div class="form-group form-actions">
                        <div class="col-xs-9 col-xs-offset-3">
                            <button type="submit" name="submit" class="btn btn-sm btn-primary">
                                <i class="fa fa-plus"></i> Add Partner
                            </button>
                        </div>
                    </div>
                </form>

                <!-- END Add Contact Content -->
            </div>
            <!-- END Add Contact Block -->
        </div>
    </div>
    <!-- END Main Row -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>
<?php include 'inc/template_end.php'; ?>