<?php
/**
 * page_footer.php
 *
 * Author: pixelcave
 *
 * The footer of each page
 *
 */
?>
            <!-- Footer -->
            <footer class="clearfix">
                <div class="pull-right">
                    Crafted with <i class="fa fa-heart text-danger"></i> by <a href="https://canontechnologies.canongadgets.com/" target="_blank">Canon Technologies</a>
                </div>
                <div class="pull-left">
                    <span id="year-copy"></span> &copy; <a href="https://canontechnologies.canongadgets.com/" target="_blank"><?php echo $template['name'] . ' ' . $template['version']; ?></a>
                </div>
            </footer>
            <!-- END Footer -->
        </div>
        <!-- END Main Container -->
    </div>
    <!-- END Page Container -->
</div>
<!-- END Page Wrapper -->

<!-- Scroll to top link, initialized in js/app.js - scrollToTop() -->
<a href="#" id="to-top"><i class="fa fa-angle-double-up"></i></a>

<!-- User Settings, modal which opens from Settings link (found in top right user menu) and the Cog link (found in sidebar user info) -->
<div id="modal-user-settings" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Settings</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="update_password.php" id="update_password_form" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                    <fieldset>
                        <legend>Vital Info</legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Username</label>
                            <div class="col-md-8">
                                <p class="form-control-static"><?php echo $name ?></p>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-email">Email</label>
                            <div class="col-md-8">
                                <input type="email" id="user-settings-email" name="email" class="form-control" value="<?php echo $email ?>" readonly>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-notifications">Email Notifications</label>
                            <div class="col-md-8">
                                <label class="switch switch-primary">
                                    <input type="checkbox" id="user-settings-notifications" name="user-settings-notifications" value="1" checked>
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Password Update</legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Old Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-password" name="old_password" class="form-control" placeholder="Enter Old Password.." required>
                            </div>
                            <div class="text-danger col-md-8" id="wrong_old_password"> </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">New Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-password" name="new_password" class="form-control" placeholder="Please choose a complex one.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-repassword">Confirm New Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-repassword" name="confirm_password" class="form-control" placeholder="..and confirm it!" required>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END User Settings -->

<script>
    $(document).ready(function(){
        $('#submit_btn').click(function(e){
            e.preventDefault();
            alert('clicked')
            $.ajax({
                url: 'update_password.php',
                method: 'POST',
                data: $(this).serialize(),
                success: function(resp) {
                  //$('#testing_box').html(resp)  
                    if(resp == 2) {
                        $('#wrong_old_password').html("Wrong old password, Please try again.");
                    }
                    /*
                    var array = resp.split(',');
                    if(array[0] == 1) {
                        $('#success_msg_container').show();
                        $('#success_msg').html(resp);
                    } else {
                        $('#danger_msg_container').show();
                        $('#danger_msg').html('<p> '+resp+' </p>');
                    } */
                   
                
                }
            })
        })
    })
</script>
