<?php
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

error_reporting(E_ALL);
ini_set('display_errors', 1);

// API endpoint and credentials
$url = "https://sms.textsms.co.ke/api/services/getbalance";
$apiKey = "512994c5dd1710497411494567e87194";
$partnerID = "11179";

// Prepare the JSON payload
$data = json_encode([
    "apikey"    => $apiKey,
    "partnerID" => $partnerID
]);

// Initialize cURL
$ch = curl_init($url);

// Open a file to log verbose output for debugging purposes
$verboseLog = fopen('curl_debug.log', 'w');

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response as string
curl_setopt($ch, CURLOPT_POST, true);           // Use POST method
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);      // Attach payload
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "Content-Length: " . strlen($data)
]);

// Enable verbose logging; this will write debug info to the file
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_STDERR, $verboseLog);

// (For testing only!) Disable SSL verification if needed
// Remove or set to true in production for secure connections
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

// Execute the request and capture the response
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// Check for cURL errors
if (curl_errno($ch)) {
    $error_msg = curl_error($ch);
    echo "cURL error: " . $error_msg;
    error_log("cURL error: " . $error_msg);
} else {
    // Log HTTP response code and response data for debugging
    error_log("HTTP Code: $httpCode; Response: " . $response);
    
    // Decode the JSON response
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse && isset($decodedResponse['credit'])) {
        // Print the updated credit
        echo $decodedResponse['credit'];
    } else {
        echo "Failed to decode response: " . $response;
        error_log("Failed to decode response: " . $response);
    }
}

// Close cURL handle and debug log file
curl_close($ch);
fclose($verboseLog);
?>
