<?php
include_once "inc/dbconn.php";
date_default_timezone_set('Africa/Nairobi');
$userid = $_SESSION['uid'];

// Get form inputs
$sponsorship_title = trim($_POST['sponsorship_title']);
$sponsorship_tier = trim($_POST['sponsorship_tier']);
$price_kes = intval($_POST['price_kes']);
$price_usd =  intval($_POST['price_usd']);
$btn_label = isset($_POST['btn_label']) && $_POST['btn_label'] !== '' ? trim($_POST['btn_label']) : 'Become a Sponsor';
$benefits_text = $_POST['benefits'];

// Validate required fields
if (empty($sponsorship_title) || empty($sponsorship_tier) || empty($price_kes) || empty($benefits_text)) {
    echo "<script>alert('Please fill in all required fields.'); location.href='packages.php';</script>";
    exit();
}

// Validate tier against ENUM values
$valid_tiers = ['Principal', 'Major', 'Supporting', 'A La Carte'];
if (!in_array($sponsorship_tier, $valid_tiers)) {
    echo "<script>alert('Invalid sponsorship tier provided.'); location.href='packages.php';</script>";
    exit();
}

// Generate slug from sponsorship title
$base_slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $sponsorship_title), '-'));
$slug = $base_slug;
$counter = 1;
while (mysqli_num_rows($connection->query("SELECT id FROM sponsorship_packages WHERE slug = '$slug'")) > 0) {
    $slug = $base_slug . '-' . $counter;
    $counter++;
}

// Save benefits to file
$benefits_filename = substr($slug, 0, 6) . "_" . uniqid("benefits_") . ".txt";
$benefits_path = "../package_benefits/" . $benefits_filename;
file_put_contents($benefits_path, $benefits_text);

// Insert into database (without image)
$query = "INSERT INTO sponsorship_packages (
    slug, sponsorship_title, sponsorship_tier, price_kes, price_usd, benefits, btn_label
) VALUES (
    '$slug', '$sponsorship_title', '$sponsorship_tier', $price_kes, $price_usd, '$benefits_filename', '$btn_label'
)";

if ($connection->query($query)) {
    echo "<script>alert('Sponsorship package added successfully.'); location.href='packages.php';</script>";
} else {
    echo "<script>alert('Error adding package.'); location.href='packages.php';</script>";
}
?>
