<?php
include_once "inc/dbconn.php";
date_default_timezone_set('Africa/Nairobi');

if (!isset($_SESSION['uid'])) {
    echo "<script>alert('User not logged in'); location.href='login.php';</script>";
    exit;
}

$userid = $_SESSION['uid'];
$code_title = trim($_POST['code_title']);
$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $code_title)));
$language = trim($_POST['language']);
$meta_title = trim($_POST['meta_title']);
$meta_description = trim($_POST['meta_description']);
$description = trim($_POST['description']);
$publish_status = isset($_POST['publish_status']) ? 1 : 0;

if (empty($code_title)) {
    echo "<script>alert('Title is required'); location.href='add_codelab.php';</script>";
    exit;
}

// Prevent duplicate
$check = $connection->query("SELECT id FROM codelabs WHERE slug = '$slug'");
if ($check->num_rows > 0) {
    echo "<script>alert('Duplicate title'); location.href='add_codelab.php';</script>";
    exit;
}

// Generate prefix
$prefix = substr(preg_replace('/[^A-Za-z0-9]/', '', $code_title), 0, 6);

// Save description file
$descFile = $prefix . '@' . uniqid('desc_', true) . '.txt';
$descPath = "../codelab_data/" . $descFile;
file_put_contents($descPath, $description);

// Save meta description file
$metaFile = $prefix . '@' . uniqid('meta_', true) . '.txt';
$metaPath = "../codelab_data/" . $metaFile;
file_put_contents($metaPath, $meta_description);

// Use one image as thumbnail
$image_files = glob("uploads/{$userid}/*.{jpg,jpeg,png,webp,gif,jfif}", GLOB_BRACE);
$thumbnail = null;
if (!empty($image_files)) {
    $firstImage = $image_files[0];
    $ext = pathinfo($firstImage, PATHINFO_EXTENSION);
    $thumbnail = $prefix . "_thumb_" . uniqid() . "." . $ext;
    rename($firstImage, "../codelab_images/" . $thumbnail);
}

// Upload code files
$codeList = '';
$codeTarget = "../codelabs/";
if (!empty($_FILES['code_files']['name'][0])) {
    foreach ($_FILES['code_files']['tmp_name'] as $index => $tmpPath) {
        $original = $_FILES['code_files']['name'][$index];
        $ext = pathinfo($original, PATHINFO_EXTENSION);
        $safeName = $prefix . "_code_" . uniqid() . "." . $ext;
        if (move_uploaded_file($tmpPath, $codeTarget . $safeName)) {
            $codeList .= $safeName . ",";
        }
    }
    $codeList = rtrim($codeList, ',');
}

// Insert to DB
$stmt = $connection->prepare("
    INSERT INTO codelabs (
        code_title, slug, language, thumbnail, code_files,
        description_file, meta_title, meta_description_file,
        publish_status, created_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "ssssssssii",
    $code_title, $slug, $language, $thumbnail, $codeList,
    $descFile, $meta_title, $metaFile,
    $publish_status, $userid
);

if ($stmt->execute()) {
    echo "<script>alert('Codelab added successfully'); location.href='codelab.php';</script>";
} else {
    file_put_contents("db_errors.log", "DB Error: " . $stmt->error . "\n", FILE_APPEND);
    echo "<script>alert('Failed to save codelab'); location.href='add_codelab.php';</script>";
}
?>
